/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.converters;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.ActionUtils;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

/**
 * StringToLong Converter Test Action Handler.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 * @since Version 4.0
 */
public class StringToLongConverter extends AbstractActionPipelineProcessor {
    private MessagePayloadProxy payloadProxy;

    public StringToLongConverter(ConfigTree config) {
        payloadProxy = new MessagePayloadProxy(config,
                                               new String[] {ActionUtils.POST_ACTION_DATA},
                                               new String[] {ActionUtils.POST_ACTION_DATA});
    }

    /* (non-Javadoc)
     * @see org.jboss.soa.esb.actions.ActionProcessor#processAction(java.lang.Object)
     */
    public Message process(Message message) throws ActionProcessingException {
        Object oCurr = null;

        try {
            oCurr = payloadProxy.getPayload(message);
        } catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }

        if(!(oCurr instanceof String)) {
            throw new ActionProcessingException("This action handler only accepts String object instances.");
        }
        
        try {
            payloadProxy.setPayload(message, new Long((String)oCurr));
        } catch (NumberFormatException e) {
            throw new ActionProcessingException("'" + oCurr + "' is not a valid long value.");
        } catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }

        return message;
    }
}
