/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. 
 * See the copyright.txt in the distribution for a full listing 
 * of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License, v. 2.0.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License,
 * v. 2.0 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.internal.soa.esb.util;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Properties;

import javax.xml.stream.XMLStreamReader;

import org.jboss.soa.esb.testutils.StringUtils;

import junit.framework.TestCase;

/**
 * Tests associated with the XML helper class.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class XMLHelperUnitTest extends TestCase
{
    public void testReplaceSystemProperties()
        throws Exception
    {
        final Properties props = System.getProperties() ;
        props.setProperty("test.property.attributeValue1", " testAttributeValue1 ") ;
        props.setProperty("test.property.attributeValue2", "testAttributeValue2") ;
        props.setProperty("test.property.attributeValue3", "${test.property.attributeValue1}") ;
        props.setProperty("test.property.attributeValue4", "<testAttr/>") ;
        props.setProperty("test.property.textValue1", "testTextValue1") ;
        props.setProperty("test.property.textValue2", "${test.property.textValue2}") ;
        props.setProperty("test.property.textValue3", "<testText/>") ;
        
        final InputStream is = getClass().getResourceAsStream("replaceSystemProperties_source.xml") ;
        final XMLStreamReader streamReader = XMLHelper.getXMLStreamReader(is) ;
        final String encoding = streamReader.getEncoding() ;
        
        final StringWriter sw = new StringWriter() ;
        
        XMLHelper.replaceSystemProperties(streamReader,
            XMLHelper.getXMLStreamWriter(sw)) ;
        final String contents = sw.toString() ;
        
        final String expectedContents = StreamUtils.getResourceAsString("replaceSystemProperties_expected.xml", encoding) ;

        final boolean match = StringUtils.compareXMLContent(expectedContents, contents) ;
        assertTrue("System property replacement", match) ;
    }
}
