/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import static org.junit.Assert.*;
import static org.jboss.soa.esb.addressing.eprs.JMSEpr.*;

import java.util.Map;
import java.util.Properties;

import javax.naming.Context;

import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/**
 * Unit Test for JmsConnectionPoolContainer
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>				
 *
 */
public class JmsConnectionPoolContainerUnitTest
{
	private String connectionFactory = "/ConnectionFactory";
	
	@Test
	public void createPoolKey_null_environment()
	{
		final Properties env = null;
		Map<String, String> poolKey = JmsConnectionPoolContainer.createPoolKey( env, connectionFactory);
		
		assertEquals( connectionFactory, poolKey.get( CONNECTION_FACTORY_TAG ) );
	}
	
	@Test
	public void createPoolKey_with_naming_security_properties()
	{
		final String username = "daniel";
		final String password = "passwd";
		final Properties env = new Properties();
		env.put( Context.SECURITY_PRINCIPAL, username );
		env.put( Context.SECURITY_CREDENTIALS, password );
		Map<String, String> poolKey = JmsConnectionPoolContainer.createPoolKey( env, connectionFactory);
		assertEquals( username, poolKey.get( Context.SECURITY_PRINCIPAL ) );
		assertEquals( password, poolKey.get( Context.SECURITY_CREDENTIALS ) );
	}
	
	@Test
	public void createPoolKey_with_jms_security_properties()
	{
		final String username = "daniel";
		final String password = "passwd";
		final Properties env = null;
		Map<String, String> poolKey = JmsConnectionPoolContainer.createPoolKey( env, connectionFactory,
				username, password);
		assertEquals( username, poolKey.get( JMSEpr.JMS_SECURITY_PRINCIPAL_TAG ) );
		assertEquals( password, poolKey.get( JMSEpr.JMS_SECURITY_CREDENTIAL_TAG ) );
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( JmsConnectionPoolContainerUnitTest.class );
	}

}
