/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.couriers;

import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.message.Message;

/**
 * Mock Courier impl.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MockCourier implements TwoWayCourier {

    public boolean deliveryResult = true;
    public Message message;
    public Message pickupMessage;
    public boolean deliveryAttempted = false;
    public CourierException courierException;
    public MalformedEPRException malformedEPRException;

    public MockCourier(boolean deliveryResult) {
        this.deliveryResult = deliveryResult;
    }

    public MockCourier(CourierException courierException) {
        this.courierException = courierException;
    }

    public MockCourier(MalformedEPRException malformedEPRException) {
        this.malformedEPRException = malformedEPRException;
    }

    public boolean deliver(Message message) throws CourierException, MalformedEPRException {
        deliveryAttempted = true;

        if(courierException != null) {
            throw courierException;
        } else if(malformedEPRException != null) {
            throw malformedEPRException;
        }

        if(deliveryResult) {
            // Only set the message ref if "successful"...
            this.message = message;
        }
        
        return deliveryResult;
    }

    public void cleanup() {
    }

    public void reset() {
        message = null;
        deliveryAttempted = false;
    }

    public Message pickup(long waitTime) throws CourierException, CourierTimeoutException {
        return pickupMessage;
    }

    public Message pickup(long waitTime, EPR epr) throws CourierException, CourierTimeoutException, MalformedEPRException {
        return pickupMessage;
    }

    public void setToEpr(EPR toEPR) throws CourierException, MalformedEPRException {
    }

    public void setReplyToEpr(EPR replyToEPR) throws CourierException, MalformedEPRException {
    }
}
