/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.couriers;

import static org.junit.Assert.*;

import java.util.Properties;

import javax.jms.JMSException;
import javax.jms.Session;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.junit.Before;
import org.junit.Test;

/**
 * Unit test for JmsCourier
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>				
 *
 */
public class JmsCourierIntegrationTest
{
	@SuppressWarnings("unused")
	private Logger log = Logger.getLogger( JmsCourierIntegrationTest.class );
	
	private JmsCourier jmsCourier;
	
	@Test
	public void getJmsSession() throws CourierException, JMSException
	{
		Session jmsSession = jmsCourier.getJmsSession();
		assertFalse( jmsSession.getTransacted() );
		jmsCourier.cleanup();
	}
	
	@Before
	public void createJmsCourierInstance() throws CourierException
	{
		final Properties env = null;
		final String messageSelector = null;
		final boolean persistent = true;
		final boolean transacted = true;
		JMSEpr epr = new JMSEpr(JMSEpr.ONE_ONE_PROTOCOL, 
				JMSEpr.QUEUE_TYPE, 
				"queue/A",
				"ConnectionFactory",
				env,
				messageSelector,
				persistent,
				transacted);
		jmsCourier = new JmsCourier( epr );
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( JmsCourierIntegrationTest.class );
	}

}
