/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.routing.cbr;

import java.util.List;

import org.jboss.soa.esb.helpers.ConfigTree;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.routing.MessageRouterException;

/**
 * Content Based Router Interface. Separates implementation from the runtime, allowing
 * the ESB to support different ways of doing CBR.
 * 
 * @author kurt.stam@redhat.com
 * 
 */
public interface ContentBasedRouter
{  
	public abstract void setConfigTree(ConfigTree configTree);
	
	/**
	 * Route a message using a certain ruleSet and reference a custom
	 * Domain Specific Language (DSL).
	 * 
	 * @param ruleSet -
	 *            String reference to a file which contains a ruleSet.
	 * @param ruleLanguage -
	 *            String reference to a file which contais a custom rule
	 *            language definition
	 * @param ruleReload -
	 *            if set to true, a ruleSet update should result in reloading
	 *            the ruleSet.
	 * @param message -
	 *            Message that needs routing.
     * @param objectList - a list with additional objects (typically pulled from the message)
     * 
	 * @return List of routing destinations.
	 */
	public abstract List<String> route (String ruleSet, String ruleLanguage,
			boolean ruleReload, Message message, List<Object> objectList) throws MessageRouterException;

	/**
	 * Route a message using a certain ruleSet.
	 * 
	 * @param ruleSet -
	 *            String reference to a file which contains a ruleSet.
	 * @param ruleReload -
	 *            if set to true, a ruleSet update should result in reloading
	 *            the ruleSet.
	 * @param message -
	 *            Message that needs routing.
     * @param objectList - a list with additional objects (typically pulled from the message)
     * 
	 * @return List of routing destinations.
	 */
	public abstract List<String> route (String ruleSet, boolean ruleReload,
			Message message, List<Object> objectList) throws MessageRouterException;
}
