/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.registry;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.util.ClassUtil;

/**
 * Returns an Instance of the Registry.
 * 
 * @author kstam
 * 
 */
public class RegistryFactory
{
	private static Logger logger = Logger.getLogger(RegistryFactory.class);

   private static Registry singleton;

   public static synchronized void setRegistry(Registry registry)
   {
      singleton = registry;
   }


    public static Registry getRegistry() throws RegistryException {
        // no synchronized block as there should be a service that initializes this
        if (singleton != null) {
            return singleton;
        }

        return createRegistry();
    }

    public static Registry createRegistry()
           throws RegistryException
   {
      Registry registry = null;
      String className = Configuration.getRegistryImplementationClass();
      logger.log(Level.DEBUG, "Going to load " + className);

      try
		{
            // instruct class loader to load the Registry Implementation
         Class registryClass = ClassUtil.forName(className, RegistryFactory.class);
         // Try to instance the Registry
         registry = (Registry) registryClass.newInstance();
      }
      catch (ClassNotFoundException cnfex)
      {
         throw new RegistryException("Registry Implementation=" + className
               + " not found", cnfex);
      }
      catch (Exception e)
      {
         e.printStackTrace();

         throw new RegistryException("Invocation exception. "
               + e.getLocalizedMessage(), e);
      }

      return registry;
   }
}
