/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services;

public class DefaultEncryptionFactory
{
	public static Encryption getEncrypter()
	{
		return new DummyEncrypter();

	} //________________________________

	public static Encryption getEncrypter(Object p_o)
	{
		return new DummyEncrypter();

	} //________________________________

	/**
	 *  This is a dummy class to provide dummy
	 *  encrypt/decrypt methods for a byte[]
	 *
	 */
	private static class DummyEncrypter implements Encryption
	{
//	  private static Cipher s_oCC;
//	  static
//	  { try { s_oCC = Cipher.getInstance("DES"); }
//	    catch (Exception e) { e.printStackTrace(); }
//	  }
	  public byte [] encrypt (byte [] p_ba, Object p_oParms)
	         throws EncryptionFailedException
	  {
		  return  p_ba;
	  } //__________________________________

	  public byte [] decrypt (byte [] p_ba, Object p_oParms)
	         throws EncryptionFailedException
	  {
		  return p_ba;
	  } //__________________________________
	} //___________________________________________________

} //____________________________________________________________________________