package org.jboss.soa.esb.message.helper.content;

import org.jboss.soa.esb.message.format.MessageType;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * You get a message of a specific type when you need it and it
 * is initialized with state.
 * 
 * @author Mark Little
 *
 */

public class XMLMessageFactory extends ContentManager
{	
	protected XMLMessageFactory ()
	{
		super(MessageType.JBOSS_XML);
	}
	
	public static final XMLMessageFactory getInstance ()
	{
		synchronized (_lock)
		{
			if (_theInstance == null)
				_theInstance = new XMLMessageFactory();
		}
		
		return _theInstance;
	}
	
	private static XMLMessageFactory _theInstance = null;
	private static final Object _lock = new Object();
}
