package org.jboss.soa.esb.message.format;

import java.net.URI;

import org.jboss.soa.esb.common.ModulePropertyManager;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * You get a message of a specific format when you need it. Obviously that format
 * may not be suitable for the service (hopefully you've got that contractual
 * information a priori, but maybe not) and in which case some
 * translation/transformation may be necessary.
 * 
 * This should not be confused with the type of payload, which can also be chosen
 * after creation.
 * 
 * @author Mark Little
 * 
 */

// bad name ;-) Should be MessageFormat or some such.

public abstract class MessageType
{
    public static final String DEFAULT_URI = "org.jboss.soa.esb.message.default.uri";

    public static final String SERIALIZED_URI = "urn:jboss/esb/message/type/JAVA_SERIALIZED";

    public static final String XML_URI = "urn:jboss/esb/message/type/JBOSS_XML";

    /*
         * DO NOT reorder this list. New types may be added as required.
         */

    public static URI JBOSS_XML = null;

    public static URI JAVA_SERIALIZED = null;

    public static URI DEFAULT_TYPE = null;

    static
    {
	try
	{
	    JBOSS_XML = new URI(XML_URI);
	    JAVA_SERIALIZED = new URI(SERIALIZED_URI);

	    String defaultURI = ModulePropertyManager.getPropertyManager(
		    ModulePropertyManager.CORE_MODULE).getProperty(DEFAULT_URI);

	    if (defaultURI != null)
		DEFAULT_TYPE = new URI(defaultURI);
	    else
		DEFAULT_TYPE = JBOSS_XML;
	}
	catch (Exception ex)
	{
	    throw new ExceptionInInitializerError(ex.toString());
	}

    }

}
