/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.lifecycle;

/**
 * Exception representing errors in a managed lifecycle.
 * @author kevin
 */
public class ManagedLifecycleException extends Exception
{
    /**
     * serial version UID of this exception.
     */
    private static final long serialVersionUID = -2461030864678547990L;

    /**
     * Construct a default managed lifecycle exception.
     */
    public ManagedLifecycleException()
    {
    }

    /**
     * Construct a managed lifecycle exception with the specified message.
     * @param message The exception message.
     */
    public ManagedLifecycleException(final String message) 
    {
	super(message);
    }

    /**
     * Construct a managed lifecycle exception with the associated cause.
     * @param cause The associated cause.
     */
    public ManagedLifecycleException(final Throwable cause)
    {
	super(cause);
    }

    /**
     * Construct a managed lifecycle exception with the specified message and associated cause.
     * @param message The exception message.
     * @param cause The associated cause.
     */
    public ManagedLifecycleException(String message, Throwable cause)
    {
	super(message, cause);
    }
}
