/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.soa.esb.listeners.ha;

import java.util.List;

import org.jboss.soa.esb.addressing.EPR;
/**
 * Holder for a list of eprs all belonging to the same service.
 * 
 * Code based on jbossas ha framework.
 *  
 * @author <a href="mailto:kurt@osconsulting.org">Kurt Stam</a>.
 *
 */


public interface ServiceClusterInfo
{
    public String getServiceName ();
   /**
    * Gets the list of eprs.
    */
   public List<EPR> getEPRs ();
   
   /**
    * Remove the given epr from the list of eprs.
    *
    * @param target the epr
    * @return the updated list of EPRs
    */
   public List<EPR> removeDeadEPR(EPR epr);
   
   /**
    * Updates the eprs.
    */
   public List<EPR> updateClusterInfo (List<EPR> eprs);
  
   // arbitrary usage by the LoadBalancePolicy implementation
   // We could have used an HashMap but the lookup would have taken
   // much more time and we probably don't need as much flexibility
   // (+ it is slow for a simple int)
   //
   public int getCursor();
   public int setCursor (int cursor);
   
   public final static int UNINITIALIZED_CURSOR = 999999999;
}
