/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies;

import java.io.File;
import org.jboss.soa.esb.listeners.gateway.GatewayException;

/**
 * A strategy for handling remote write operations.
 * 
 * @author <a href="daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 *
 */
public interface RemoteFileSystemStrategy
{
	/**
	 * Initialize this RemoteFileSystemStrategy
	 * 
	 * @param configFile
	 * @throws Exception
	 */
	void init( String configFile ) throws RemoteFileSystemStrategyException;
	
	/**
	 * filters the file array passed in. 
	 * 
	 * @return	File[]	list of files that should worked on
	 * @throws GatewayException
	 */
	File[] filterFileList( File[] files ) throws RemoteFileSystemStrategyException;
	
	/**
	 * 
	 * @param file		the file to delete
	 * @return true	if the file was sucessfully deleted
	 * @throws GatewayException
	 */
	boolean deleteFile( File file ) throws RemoteFileSystemStrategyException;
	
	/**
	 * 
	 * @param from		the file to rename
	 * @param to		the target file
	 * @return true	if the file was sucessfully renamed
	 * @throws GatewayException
	 */
	boolean renameFile( File from, File to ) throws RemoteFileSystemStrategyException;
	
	/**
	 * 
	 * @param file		the current file the system is working on
	 * @param suffix	a suffix to append to the file.
	 * @return	File	either the file with the appended suffix or 
	 * 					without.This depends on the implementation.
	 */
	File getWorkFileName( File file, String suffix );
	
	/**
	 * Stop of clean upp anything that needs to be perforemed 
	 * upon shutdown.
	 */
	void stop();

	/**
	 * Clean upp anything that needs to be perforemed 
	 * upon destruction.
	 */
	void destroy();

}
