/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners;

import java.io.File;


import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.internal.soa.esb.util.Exit;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.config.ConfigurationController;

public class StandAloneBootStrapper
{
	private ConfigurationController _confController;

    private static Logger _logger = Logger
			.getLogger(StandAloneBootStrapper.class);

    public static void main (String[] args) throws Exception
	{
        System.out.println("+----------------------------------------------------------+");
        System.out.println("|                                                          |");
        System.out.println("|     Starting JBossESB...                                 |");
        System.out.println("|                                                          |");
        System.out.println("+----------------------------------------------------------+");
        
		Exception eT = null;
		if (args.length < 1)
		{
			eT = new Exception(
					"No configuration file specified - Ending immediately");
			_logger.fatal(eT);
			throw eT;
		}

		String configName = args[0];
        File configFile = new File(configName);
        if (configFile.exists()) {
           System.out.println("Reading config from " + configFile.getAbsolutePath());
            String loggerConfig = configFile.getParent() + "/log4j.xml";
            DOMConfigurator.configure(loggerConfig);
        } else {
            
        }
        
        long lSecondsToRun = 365 * 24 * 3600; // run for 1 year (is it enough
												// ?)
		if (args.length > 1) try
		{
            for (int i = 1; i < args.length; i++) {
                String arg = args[i];

                if(arg.startsWith("exit-port=")) {
                    try {
                        int port = Integer.parseInt(arg.substring("exit-port=".length()));
                        Exit.startListener(port);
                    } catch(NumberFormatException e) {
                        System.out.println("Invalid exit port config '" + arg + "'.");
                    }
                } else {
                    try {
                        lSecondsToRun = Long.parseLong(arg);                    
                    } catch(NumberFormatException e) {
                        System.out.println("Invalid 'secondst to run' time config '" + arg + "'.");
                    }
                }
            }
		}
		catch (Exception e)
		{
			_logger.fatal(e);
			throw e;
		}
			final StandAloneBootStrapper boot = new StandAloneBootStrapper(configName);
                        final Thread hook = new Thread() {
                            @Override
                            public void run() {
                                System.out.println("+----------------------------------------------------------+");
                                System.out.println("|                                                          |");
                                System.out.println("|     Stopping JBossESB...                                 |");
                                System.out.println("|                                                          |");
                                System.out.println("+----------------------------------------------------------+");
                                boot.requestEnd() ;
                                LifecycleResourceManager.getSingleton().cleanupAllResources() ;
                            }
                        } ;
                        LifecycleResourceManager.deactivateHook() ;
                        Runtime.getRuntime().addShutdownHook(hook) ;
			if (lSecondsToRun < 5) lSecondsToRun = 5;
			long lRunTo = System.currentTimeMillis() + 1000 * lSecondsToRun;

			while (System.currentTimeMillis() < lRunTo)
			{
				try
				{
					Thread.sleep(1000);
				}
				catch (InterruptedException e)
				{
					break;
				}
			}
	}

    public StandAloneBootStrapper (String configName) throws ConfigurationException
	{
		this(configName, null);
	}

	public StandAloneBootStrapper (String configName, String validationFileName)
			throws ConfigurationException
	{
        System.setProperty("javax.xml.registry.ConnectionFactoryClass","org.apache.ws.scout.registry.ConnectionFactoryImpl");
		runBefore();

		// TODO hardwired names?

		String listenerConfig = "jbossesb-listener.xml";
		String gatewayConfig = "jbossesb-gateway.xml";

		try
		{
			File configFile = new File(configName);
			String sParent = configFile.getParent();
			if (null == sParent) sParent = new File("").getAbsolutePath();
			else
				if (sParent.endsWith("/.") || sParent.endsWith("\\."))
					sParent = sParent.substring(0, -2 + sParent.length());
			configFile = new File(sParent, configFile.getName());

			_confController = initiateController(configFile.getAbsolutePath(),
					validationFileName, gatewayConfig, listenerConfig);

                        _logger.info("Listeners Ready");
		}
		catch (ConfigurationException ex)
		{
			requestEnd();
			
			throw ex;
		}
		catch (Exception ex)
		{
			requestEnd();
			
			throw new ConfigurationException("Cannot instantiate "+this.getClass().getSimpleName(),ex);
		}

	} // ________________________________

	public void requestEnd ()
	{
		if (_confController != null)
                {
                    _confController.requestEnd();
                    _confController.waitUntilEnded() ;
                }
		runAfter();
	} // ________________________________

	protected void runBefore ()
	{
	} // placeholder for classes that extend this bootstrapper

	protected void runAfter ()
	{
	} // placeholder for classes that extend this bootstrapper

	public ConfigurationController initiateController (String configName,
			String validationName, String gwConf, String esbConf)
			throws ConfigurationException
	{
		if (null == configName)
			throw new IllegalArgumentException(
					"Null configuration file specified");

		File configFile = new File(configName);
		if (!configFile.exists())
			throw new IllegalArgumentException(
					"Missing esb configuration file: " + configFile);

		// Remove the listener and gateway configuration files if the exist
		File configDir = configFile.getParentFile();
		if (null == configDir) configDir = new File("");
		File listenerFile = new File(configDir, esbConf);
		if (listenerFile.exists())
		{
			listenerFile.delete();
		}
		File gatewayFile = new File(configDir, gwConf);
		if (gatewayFile.exists())
		{
			gatewayFile.delete();
		}

		ConfigurationController conf = new ConfigurationController(configFile
				.toString(), validationName);
		if (listenerFile.exists() && gatewayFile.exists())
		{
                    new Thread(conf).start() ;
                    return conf;
		}

		throw new ConfigurationException(
				"Unable to generate gateway and listener configurations");
	} // ________________________________
}
