/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers.persist;

public class SqlField {
	private int m_sqlType;

	private Class m_javaType;

	private int m_sqlLength;

	private String m_fieldName;

	private boolean m_primaryKey;

	public SqlField(String pFldName, Class pJavaType, int pSqlType,
			int pFieldLength, boolean pk) {
		m_fieldName = pFldName;
		m_javaType = pJavaType;
		m_sqlType = pSqlType;
		m_sqlLength = pFieldLength;
		m_primaryKey = pk;
	}

	public int getSqlType() {
		return m_sqlType;
	}

	public Class getJavaType() {
		return m_javaType;
	}

	public int getSqlLength() {
		return this.m_sqlLength;
	}

	public String getFieldName() {
		return this.m_fieldName;
	}

	public boolean isPrimaryKey() {
		return this.m_primaryKey;
	}

	public void setSqlType(int pSqlType) {
		m_sqlType = pSqlType;
	}

	public void setJavaType(Class pJavaType) {
		m_javaType = pJavaType;
	}

	public void setSqlLength(int pSqlLength) {
		m_sqlLength = pSqlLength;
	}

	public void setFieldName(String pFieldName) {
		m_fieldName = pFieldName;
	}

	public void setPrimaryKey(boolean pPrimaryKey) {
		m_primaryKey = pPrimaryKey;
	}
} // ____________________________________________________________________________
