/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.couriers;

import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.message.Message;

public interface TwoWayCourier extends Courier, PickUpOnlyCourier
{
	/**
     * Instruct the courier to wait for a pickup in the replyToEpr
     * 
     * @param waitTime         - Pickup timeout for before giving up on this pickup. Time in millis.
     * @return                 - the message that was picked up.
     * @throws CourierException the courier fails (e.g., gets a flat tire).
	 * @throws CourierTimeoutException if the pickup timed out (nobody home).
     */
	public Message pickup(long waitTime) throws CourierException, CourierTimeoutException;
	/**
     * Instruct the courier to wait for a pickup in the specified EPR
     * 
     * @param waitTime         - Pickup timeout for before giving up on this pickup. Time in millis.
     * @param epr              - Pickup address
     * @return                 - the message that was picked up.
     * @throws CourierException the courier fails (e.g., gets a flat tire).
	 * @throws CourierTimeoutException if the pickup timed out (nobody home).
     */
	public Message pickup(long waitTime, EPR epr) throws CourierException, CourierTimeoutException, MalformedEPRException;
	/**
	 * Sets the toEPR. This can be used if the toEPR is not know at construction time of
	 * the Courier.
	 * 
	 * @param toEPR - EPR specifying the 'to' address.
	 * @throws CourierException
	 */

	public void setToEpr(EPR toEPR) throws CourierException, MalformedEPRException;
	/**
	 * Sets the replyToEPR. This can be used if the replyToEPR is not know at construction time of
	 * the Courier.
	 * 
	 * @param replyToEPR - EPR specifying the reply to address.
	 * @throws CourierException
	 */

	public void setReplyToEpr(EPR replyToEPR) throws CourierException, MalformedEPRException;
}
