package org.jboss.soa.esb.actions.templating;

import java.util.Map;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.ActionUtils;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

/**
 * <a href="http://www.stringtemplate.org">StringTemplate</a> Processor.
 * <p/>
 * Code supplied by the <a href="http://milyn.codehaus.org/Smooks">Milyn Smooks</a> project.
 *
 * @author John Doe
 */
public class StringTemplateProcessor extends AbstractActionPipelineProcessor {

    private StringTemplate template;
    private MessagePayloadProxy payloadProxy;

    public StringTemplateProcessor(ConfigTree config) {
        String path = config.getAttribute("template");
        String encoding = config.getAttribute("encoding", "UTF-8");

        if(path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if(path.endsWith(".st")) {
            path = path.substring(0, path.length() - 3);
        }

        StringTemplateGroup templateGroup = new StringTemplateGroup(path);
        templateGroup.setFileCharEncoding(encoding);
        template = templateGroup.getInstanceOf(path);
        payloadProxy = new MessagePayloadProxy(config);
        payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
    }

    public Message process(final Message message) throws ActionProcessingException {
        // First thing we do is clone the template for this message...
        StringTemplate thisTransTemplate = template.getInstanceOf();
        Map beans;
        
        try {
            beans = (Map) payloadProxy.getPayload(message);
        } catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }

        // Set the document data beans on the template and apply it...
        thisTransTemplate.setAttributes(beans);
        try {
            payloadProxy.setPayload(message, thisTransTemplate.toString());
        } catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }

        return message;
    }
}
