package org.jboss.soa.esb.actions;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.apache.log4j.Logger;

/**
 * <p/>
 * This action adds all of its attributes to the message as properties.    It was created to
 * help pass in the name of the filename to use for StoreMessageToFile for continuous integration
 * of quickstarts, but it has a more generalized purpose in that it allows anyone to set
 * message properties quickly in the jboss-esb.xml.
 * <p/>
 * An "Action Processor" performs a processing action on a message payload and returns the processing
 * result.
 * <p/>
 * Here is an example of how to use this within your jboss-esb.xml :
 * <p/>
 * <code>
 * &lt;action name="AddProperty"
 * 		class="org.jboss.soa.esb.actions.PropertySetter"&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&lt;property name="jbesbfilename" value="BPMOrchestration1Test.log"/&gt;<br/>
 * &lt;/action&gt;<br/>
 * </code>
 * <p/>
 * This will insert a property "jbesbfilename" into the message with a value of
 * "BPMOrchestration1Test.log".    There are no checks here on property names, so be careful
 * when setting properties for JMS that you only set ones with valid names.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.2.1
 * 
 */
public class PropertySetter extends AbstractActionLifecycle {

	protected ConfigTree	_config;
	private Logger logger = Logger.getLogger(PropertySetter.class);

	/**
	 * Adds attributes to the message as properties
	 * @param message message
	 * @return message
	 * @throws Exception
	 */
	public Message process(Message message) throws Exception {
		try {
			for (String key : _config.getAttributeNames()) {
				String value = _config.getAttribute(key);
				message.getProperties().setProperty(key, value);
			}
		} catch (Exception e) {
			logger.error("", e);
			throw e;
		}

		return message;
	}
		 	  
	public PropertySetter(ConfigTree config) { _config = config; } 

}
