/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.internal.soa.esb.services.registry;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryFactory;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;
import org.jboss.system.ServiceMBeanSupport;

/**
 * Service to isolate registry because of classloader dependency
 * This service can be removed if scout and jaxr dependencies are synchronzied with
 * application server.
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 1.1 $
 */
public class RegistryService extends ServiceMBeanSupport implements RegistryServiceMBean
{
   @Override
   protected void createService() throws RegistryException, ServiceNotFoundException
   {
      final Registry registry = RegistryFactory.createRegistry();
      Class[] intfs = {Registry.class};

      // create a proxy around the Registry implementation that pushes/pops the
      // scoped classloader

      InvocationHandler handler = new InvocationHandler()
      {
         public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
           {
              ClassLoader old = Thread.currentThread().getContextClassLoader();
              Thread.currentThread().setContextClassLoader(RegistryService.class.getClassLoader());
              try {
                 return method.invoke(registry, args);
              } catch (InvocationTargetException ite) {
                    throw ite.getCause();
              } catch (Exception e) {
                  throw new RegistryException(e.getMessage(), e);
              } finally {
                 Thread.currentThread().setContextClassLoader(old);
              }
           }
      };

      RegistryFactory.setRegistry((Registry)Proxy.newProxyInstance(Registry.class.getClassLoader(), intfs, handler));
   }
}
