package org.jboss.internal.soa.esb.message.format.serialized;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;

import org.jboss.soa.esb.message.Fault;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * Since ESB 4.2 GA, Fault has simply been a convenience class to view the fault
 * data within the Message body.
 */

public class FaultImpl implements Fault, Externalizable
{
	private static final long serialVersionUID = 0x0;
	
	public final static String FAULT_REASON = "org.jboss.soa.esb.message.fault.reason";
	public final static String FAULT_CODE = "org.jboss.soa.esb.message.fault.code";
	
	public FaultImpl ()
	{
		_body = null;
	}
	
	public URI getCode ()
	{
		return (URI) _body.get(FAULT_CODE);
	}
	
	public void setCode (URI code)
	{
		if (code == null)
			throw new IllegalArgumentException();
		
		_body.add(FAULT_CODE, code);
	}
	
	public String getReason ()
	{
		return (String) _body.get(FAULT_REASON);
	}
	
	public void setReason (String reason)
	{
		if (reason == null)
			throw new IllegalArgumentException();
		
		_body.add(FAULT_REASON, reason);
	}
	
	public Throwable getCause ()
	{
		return (Throwable) _body.get(THROWABLE_CONTENT);
	}
	
	public void setCause (Throwable ex)
	{
		if (ex == null)
			_body.remove(THROWABLE_CONTENT);
		else
			_body.add(THROWABLE_CONTENT, ex);
	}
	
	public String toString ()
	{
		URI code = getCode();
		String reason = getReason();
		Throwable cause = getCause();
		
		if ((code == null) && (reason == null) && (cause == null))
			return "fault: [  ]";
		else
			return "fault: [ "+((code != null) ? code : "null")+", "+((reason != null) ? reason : "null")+", "+((cause != null) ? cause : "null")+" ]";
	}

	public void writeExternal (ObjectOutput out) throws IOException
	{
		// no need to do anything
	}
	
	public void readExternal (ObjectInput in) throws IOException
	{
		// no need to do anything
	}
	
	final void setBody (BodyImpl body)
	{
		_body = body;
	}
	
	FaultImpl (BodyImpl body)
	{
		_body = body;
	}
	
	private BodyImpl _body;
	
}