/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.internal.soa.esb.message.filter;

import java.util.Map;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.InputOutputFilter;
import org.jboss.soa.esb.message.Message;

/**
 * This input/output filter can be used for message tracing. It is enabled on a global
 * basis and assumes that each message is uniquely identified by the MessageID in the
 * header: otherwise tracing specific messages is impossible to guarantee.
 * 
 * @author marklittle
 */

public class TraceFilter extends InputOutputFilter
{
    /*
     * Message properties.
     */
    
    public static final String UNLOGGABLE_MESSAGE = "org.jboss.soa.esb.message.unloggable"; // yes or no message property
	
    public Message onOutput (Message msg, Map<String, Object> params) throws CourierException
    {
	if (_enabled)
	{
	    /*
	     * If marked as unloggable then ignore this message.
	     */

	    boolean ignore = false;
	    
	    if (_permsg)
	    {
		Object unloggable = msg.getProperties().getProperty(UNLOGGABLE_MESSAGE, "no");
		
        	if (unloggable instanceof String)
        	{
        	    if (((String) unloggable).equalsIgnoreCase("yes"))
        		ignore = true;
        	}
	    }
	    
	    if (!ignore)
	    {
		_logger.info("TraceFilter.onOutput ( "+msg.getHeader()+" )");
	    }
	}
	
	return msg;
    }

    public Message onInput (Message msg, Map<String, Object> params) throws CourierException
    {
	if (_enabled)
	{
	    /*
	     * If marked as unloggable then ignore this message.
	     */

	    boolean ignore = false;
	    
	    if (_permsg)
	    {
		Object unloggable = msg.getProperties().getProperty(UNLOGGABLE_MESSAGE, "no");
		
        	if (unloggable instanceof String)
        	{
        	    if (((String) unloggable).equalsIgnoreCase("yes"))
        		ignore = true;
        	}
	    }
	    
	    if (!ignore)
	    {
		_logger.info("TraceFilter.onInput ( "+msg.getHeader()+" )");
	    }
	}
	
	return msg;
    }

    public TraceFilter ()
    {
	if (ModulePropertyManager.getPropertyManager(ModulePropertyManager.FILTER_MODULE).getProperty(Environment.MESSAGE_TRACE, "off").equalsIgnoreCase("on"))
	{
	    _enabled = true;
	}
	else
	    _enabled = false;
	
	if (ModulePropertyManager.getPropertyManager(ModulePropertyManager.FILTER_MODULE).getProperty(Environment.PER_MESSAGE_TRACE, "off").equalsIgnoreCase("on"))
	{
	    _permsg = true;
	}
	else
	    _permsg = false;
    }
    
    private boolean _enabled;
    private boolean _permsg;
    private static final Logger _logger = Logger.getLogger(TraceFilter.class);
}
