/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007,
 * @author David Fry <dfry@redhat.com>
 * @author Kurt Stam <kurt.stam@jboss.com>
 * 
 */
package org.jboss.soa.esb.oracle.aq;

/**
 * 
 * @author David Fry <dfry@redhat.com>
 * @author Kurt Stam <kurt.stam@jboss.com>
 */
public class DestinationInfo {
    
    String owner;

    String queueName;

    boolean exceptionDestination;

    boolean multipleSubscribers;

    public DestinationInfo(String owner, String queueName, boolean exceptionDestination, boolean multipleSubscribers) {
        super();
        this.owner = owner;
        this.queueName = queueName;
        this.exceptionDestination = exceptionDestination;
        this.multipleSubscribers = multipleSubscribers;
    }

    public String getQueueName() {
        return queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public boolean isExceptionDestination() {
        return exceptionDestination;
    }

    public void setExceptionDestination(boolean exception) {
        this.exceptionDestination = exception;
    }

    public boolean isMultipleSubscribers() {
        return multipleSubscribers;
    }

    public void setMultipleSubscribers(boolean multipleSubscribers) {
        this.multipleSubscribers = multipleSubscribers;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

}

