
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@ page session="true" %>
<%@ page import="
	java.util.List,
                 org.hibernate.Session,
                 org.hibernate.Transaction,
                 org.jboss.soa.esb.monitoring.MonitoringSessionFactory,
                 org.jboss.soa.esb.monitoring.pojo.*,
                 org.jboss.soa.esb.monitoring.server.StatisticsHelper" %>
<html>
<head>
    <title>JBoss ESB Monitoring Console</title>
    <link rel="stylesheet" href="style_master.css" type="text/css">
    <meta http-equiv="cache-control" content="no-cache">
</head>
<body>
<table>
    <tr>
        <td><img src="../images/logo.gif" align="left" border="0" alt="JBoss"></td>
        <td valign="middle">
            <h1>JBoss ESB Management Console</h1>
        </td>
    </tr>
</table>
<table cellpadding="5">
<tr>
    <td><a href="operations.jsp">Management</a></td>
</tr>
</table>
<hr>
<form action="collect.jsp" method="post">
    <nobr>
        Current polling interval is <b><code><%=StatisticsHelper.getCollectionInterval()%>
    </code></b> minutes.
        Press the button to manually <input type="submit" value="Collect Statistics"/>
    </nobr>
</form>
<%
    Session sess = null;
    Transaction tx = null;
    try {
        sess = MonitoringSessionFactory.getInstance().openSession();
        tx = sess.beginTransaction();
        List serverNames = StatisticsHelper.getServerNames(sess);
        for (int i = 0; i < serverNames.size(); i++) {
            String serverName = (String) serverNames.get(i);
%>
<hr>
<h1><code><%=serverName%>
</code></h1>
<%
    List objectNames = StatisticsHelper.getObjectNamesForServer(sess, serverName);
    for (int j = 0; j < objectNames.size(); j++) {
        String objectName = (String) objectNames.get(j);
%>
<li><b><%=objectName%>
</b></li>
<ul>
    <%
        List attributeNames = StatisticsHelper.getAttributes(sess, serverName, objectName);
        for (int k = 0; k < attributeNames.size(); k++) {
            JMXAttribute jmxattr = (JMXAttribute) attributeNames.get(k);
            String attributeName = jmxattr.getAttribute();
    %>
    <li><a href="attribute.jsp?servername=<%=serverName%>&id=<%=jmxattr.getId()%>"><%=attributeName%>
    </a></li>
    <%
        }
    %>
</ul>
<%
        }

    }

    if (serverNames.size() == 0) {
%>
No records found in database.
<%
        }
    }
    catch (Exception e) {
        e.printStackTrace();
    }
    finally {
        if (tx.isActive()) {
            tx.rollback();
        }
        tx = null;

        sess.flush();
        sess.close();
        sess = null;
    }
%>
</body>
</html>
