<%@ page import="java.util.List" %>
<%@ page import="org.jboss.soa.esb.listeners.config.ServicePublisher" %>
<%@ page import="org.jboss.soa.esb.services.registry.RegistryFactory" %>
<%@ page import="org.jboss.soa.esb.services.registry.Registry" %>
<%@ page import="org.jboss.soa.esb.services.registry.RegistryException" %>
<%@ page import="org.jboss.soa.esb.services.registry.ServiceNotFoundException" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="org.jboss.soa.esb.addressing.EPR" %>
<%@ page import="java.net.URI" %>
<%@ page import="org.jboss.internal.soa.esb.publish.ContractInfo" %>
<%@ page import="org.jboss.soa.esb.actions.soap.WebserviceContractPublisher" %>
<%@ page import="org.jboss.internal.soa.esb.publish.ContractPublisher" %>
<%
    List publishers = ServicePublisher.getServicePublishers();
    Registry registry = RegistryFactory.getRegistry();
    String targetServiceCat = request.getParameter("serviceCat");
    String targetServiceName = request.getParameter("serviceName");
    String targetProtocol = request.getParameter("protocol");
    ContractInfo contractInfo = null;
    String contractData = null;
    List eprs;

    try {
        List allEprs = (List) registry.findEPRs(targetServiceCat, targetServiceName);
        eprs = new ArrayList(allEprs.size());

        for (int i = 0; i < allEprs.size(); i++) {
        	EPR epr = (EPR) allEprs.get(i);
            URI eprURI = URI.create(epr.getAddr().getAddress());
            String protocol = eprURI.getScheme();

        	if (protocol.equalsIgnoreCase(targetProtocol)) {
        		eprs.add(epr);
        	}

        }
    } catch (ServiceNotFoundException e) {
        // ignore for now - just return an empty list
        eprs = new ArrayList();
    } catch (RegistryException e) {
        // ignore for now - just return an empty list
        eprs = new ArrayList();
    }

    // JBESB-1547 - Contract console should generate HTTP 404 when asking for non-deployed service WSDL
    if (eprs == null || eprs.isEmpty()) {
        response.sendError(HttpServletResponse.SC_NOT_FOUND);
		return;
    }

    for (int i = 0; i < publishers.size() && contractInfo == null; i++) {
        ServicePublisher publisher = (ServicePublisher) publishers.get(i);
        String serviceCategory = publisher.getCategory();
        String serviceName = publisher.getServiceName();

        if (publisher.getContractPublisher() == null) {
            continue;
        } else if (!serviceCategory.equalsIgnoreCase(targetServiceCat) ||
                !serviceName.equalsIgnoreCase(targetServiceName)) {
            continue;
        }

        for (int ii = 0; ii < eprs.size(); ii++) {
            EPR epr = (EPR) eprs.get(ii);

            ContractPublisher contractPublisher = publisher.getContractPublisher();

            if(contractPublisher instanceof WebserviceContractPublisher) {
                contractInfo = ((WebserviceContractPublisher)contractPublisher).getContractInfo(epr, request);
            } else {
                contractInfo = contractPublisher.getContractInfo(epr);
            }
            break;
        }

        if (contractInfo != null && contractInfo.getData() != null) {
            contractData = contractInfo.getData();
            response.setContentType(contractInfo.getMimeType());
        }
    }

    if (contractData == null) {
        contractData = "<Unavailable/>";
        response.setContentType("text/xml");
    }
%><%= contractData %>
