/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rules.ObjectFilter;
import javax.rules.admin.RuleExecutionSet;
import org.drools.IntegrationException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.jsr94.rules.Jsr94FactHandleFactory;
import org.drools.jsr94.rules.admin.RuleImpl;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.FactHandleFactory;

public class RuleExecutionSetImpl
implements RuleExecutionSet {
    private static final long serialVersionUID = 1L;
    private String description;
    private String defaultObjectFilterClassName;
    private Map properties;
    private RuleBase ruleBase;
    private Package pkg;
    private ObjectFilter objectFilter;

    RuleExecutionSetImpl(Package package_, Map map) throws IntegrationException {
        this.properties = null == map ? new HashMap() : map;
        this.pkg = package_;
        this.description = package_.getName();
        ReteooRuleBase reteooRuleBase = new ReteooRuleBase((FactHandleFactory)new Jsr94FactHandleFactory());
        reteooRuleBase.addPackage(package_);
        this.ruleBase = reteooRuleBase;
    }

    public synchronized ObjectFilter getObjectFilter() {
        if (this.objectFilter != null) {
            return this.objectFilter;
        }
        if (this.defaultObjectFilterClassName != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = RuleExecutionSetImpl.class.getClassLoader();
            }
            try {
                Class<?> clazz = classLoader.loadClass(this.defaultObjectFilterClassName);
                this.objectFilter = (ObjectFilter)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.toString());
            }
        }
        return this.objectFilter;
    }

    public WorkingMemory newWorkingMemory() {
        return this.ruleBase.newWorkingMemory();
    }

    public String getName() {
        return this.pkg.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public Object getProperty(Object object) {
        return this.properties.get(object);
    }

    public void setProperty(Object object, Object object2) {
        this.properties.put(object, object2);
    }

    public void setDefaultObjectFilter(String string) {
        this.defaultObjectFilterClassName = string;
    }

    public String getDefaultObjectFilter() {
        return this.defaultObjectFilterClassName;
    }

    public List getRules() {
        ArrayList<RuleImpl> arrayList = new ArrayList<RuleImpl>();
        Rule[] ruleArray = this.pkg.getRules();
        for (int i = 0; i < ruleArray.length; ++i) {
            arrayList.add(new RuleImpl(ruleArray[i]));
        }
        return arrayList;
    }
}

