/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

public final class CharacterRedirects {
    public static boolean isHighSurrogate(char ch) {
        return false;
    }

    public static boolean isLowSurrogate(char ch) {
        return false;
    }

    public static boolean isSurrogatePair(char high, char low) {
        return false;
    }

    public static int charCount(int codePoint) {
        return 1;
    }

    public static int toCodePoint(char high, char low) {
        return 63;
    }

    public static int codePointAt(CharSequence seq, int index) {
        return seq.charAt(index);
    }

    public static int codePointAt(char[] a, int index) {
        return a[index];
    }

    public static int codePointAt(char[] a, int index, int limit) {
        if (index > limit) {
            throw new IndexOutOfBoundsException("index is greater than limit in Character.codePointAt()");
        }
        return a[index];
    }

    public static int codePointBefore(CharSequence seq, int index) {
        return seq.charAt(index - 1);
    }

    public static int codePointBefore(char[] a, int index) {
        return a[index - 1];
    }

    public static int codePointBefore(char[] a, int index, int start) {
        return a[index + start - 1];
    }

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        dst[dstIndex] = (char)codePoint;
        return 1;
    }

    public static char[] toChars(int codePoint) {
        return new char[]{(char)codePoint};
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > seq.length() || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("Arguments provided to codePointCount are out of range");
        }
        return endIndex - beginIndex;
    }

    public static int codePointCount(char[] a, int offset, int count) {
        if (offset < 0 || count < 0 || offset + count > a.length) {
            throw new IndexOutOfBoundsException("Arguments provided to codePointCount are out of range");
        }
        return count;
    }

    public static int offsetByCodePoints(CharSequence seq, int index, int codePointOffset) {
        int length = seq.length();
        if (index > length || codePointOffset + index > length || codePointOffset + index < 0) {
            throw new IndexOutOfBoundsException("Arguments provided to offsetByCodePoints are out of range");
        }
        return index + codePointOffset;
    }

    public static int offsetByCodePoints(char[] a, int start, int count, int index, int codePointOffset) {
        if (index + start > count || codePointOffset + index + start > count || codePointOffset + index + start < 0) {
            throw new IndexOutOfBoundsException("Arguments provided to offsetByCodePoints are out of range");
        }
        return start + index + codePointOffset;
    }

    public static boolean isLowerCase(int codePoint) {
        return codePoint <= 65535 && Character.isLowerCase((char)codePoint);
    }

    public static boolean isUpperCase(int codePoint) {
        return codePoint <= 65535 && Character.isUpperCase((char)codePoint);
    }

    public static boolean isTitleCase(int codePoint) {
        return codePoint <= 65535 && Character.isTitleCase((char)codePoint);
    }

    public static boolean isDigit(int codePoint) {
        return codePoint <= 65535 && Character.isDigit((char)codePoint);
    }

    public static boolean isDefined(int codePoint) {
        return codePoint <= 65535 && Character.isDefined((char)codePoint);
    }

    public static boolean isLetter(int codePoint) {
        return codePoint <= 65535 && Character.isLetter((char)codePoint);
    }

    public static boolean isLetterOrDigit(int codePoint) {
        return codePoint <= 65535 && Character.isLetterOrDigit((char)codePoint);
    }

    public static boolean isJavaIdentifierStart(int codePoint) {
        return codePoint <= 65535 && Character.isJavaIdentifierStart((char)codePoint);
    }

    public static boolean isJavaIdentifierPart(int codePoint) {
        return codePoint <= 65535 && Character.isJavaIdentifierPart((char)codePoint);
    }

    public static boolean isUnicodeIdentifierStart(int codePoint) {
        return codePoint <= 65535 && Character.isUnicodeIdentifierStart((char)codePoint);
    }

    public static boolean isUnicodeIdentifierPart(int codePoint) {
        return codePoint <= 65535 && Character.isUnicodeIdentifierPart((char)codePoint);
    }

    public static boolean isIdentifierIgnorable(int codePoint) {
        return codePoint <= 65535 && Character.isIdentifierIgnorable((char)codePoint);
    }

    public static int toLowerCase(int codePoint) {
        return codePoint <= 65535 ? (int)Character.toLowerCase((char)codePoint) : codePoint;
    }

    public static int toUpperCase(int codePoint) {
        return codePoint <= 65535 ? (int)Character.toUpperCase((char)codePoint) : codePoint;
    }

    public static int toTitleCase(int codePoint) {
        return codePoint <= 65535 ? (int)Character.toTitleCase((char)codePoint) : codePoint;
    }

    public static int digit(int codePoint, int radix) {
        return codePoint <= 65535 ? Character.digit((char)codePoint, radix) : -1;
    }

    public static int getNumericValue(int codePoint) {
        return codePoint <= 65535 ? Character.getNumericValue((char)codePoint) : -1;
    }

    public static boolean isSpaceChar(int codePoint) {
        return codePoint <= 65535 && Character.isSpaceChar((char)codePoint);
    }

    public static boolean isWhitespace(int codePoint) {
        return codePoint <= 65535 && Character.isWhitespace((char)codePoint);
    }

    public static boolean isISOControl(int codePoint) {
        return codePoint <= 65535 && Character.isISOControl((char)codePoint);
    }

    public static int getType(int codePoint) {
        return codePoint <= 65535 ? Character.getType((char)codePoint) : 0;
    }

    public static byte getDirectionality(int codePoint) {
        return codePoint <= 65535 ? Character.getDirectionality((char)codePoint) : (byte)-1;
    }

    public static boolean isMirrored(int codePoint) {
        return codePoint <= 65535 ? Character.isMirrored((char)codePoint) : false;
    }

    public static char reverseBytes(char ch) {
        return (char)(ch << 8 | ch >>> 8);
    }
}

