/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.color.ColorSpace;

public final class SimpleCMYKColorSpace
extends ColorSpace {
    private ColorSpace csRGB = ColorSpace.getInstance(1004);

    public SimpleCMYKColorSpace() {
        super(9, 4);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof SimpleCMYKColorSpace;
    }

    public float[] toRGB(float[] colorvalue) {
        float K = colorvalue[3];
        float C = colorvalue[0] - K;
        float M = colorvalue[1] - K;
        float Y = colorvalue[2] - K;
        return new float[]{1.0f - C, 1.0f - M, 1.0f - Y};
    }

    public float[] fromRGB(float[] rgbvalue) {
        float C = 1.0f - rgbvalue[0];
        float M = 1.0f - rgbvalue[1];
        float Y = 1.0f - rgbvalue[2];
        float K = Math.min(C, Math.min(M, Y));
        return new float[]{C, M, Y, K};
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        return this.csRGB.toCIEXYZ(this.toRGB(colorvalue));
    }

    public float[] fromCIEXYZ(float[] xyzvalue) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(xyzvalue));
    }
}

