/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.FMParserConstants;
import freemarker.core.TemplateObject;
import freemarker.core.Token;
import freemarker.template.utility.SecurityUtilities;
import java.io.IOException;

public class ParseException
extends IOException
implements FMParserConstants {
    protected boolean specialConstructor;
    public Token currentToken;
    public int columnNumber;
    public int lineNumber;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = SecurityUtilities.getSystemProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    protected ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message, int lineNumber, int columnNumber) {
        super(message);
        this.specialConstructor = false;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ParseException(String message, TemplateObject tobj) {
        super(message);
        this.specialConstructor = false;
        this.lineNumber = tobj.beginLine;
        this.columnNumber = tobj.beginColumn;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String retval = this.customGetMessage();
        if (retval != null) {
            return retval;
        }
        String expected = "";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = expected + "...";
            }
            expected = expected + this.eol + "    ";
        }
        retval = "Encountered \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + this.tokenImage[0];
                break;
            }
            retval = retval + this.add_escapes(tok.image);
            tok = tok.next;
        }
        retval = retval + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        retval = retval + "." + this.eol;
        retval = this.expectedTokenSequences.length == 1 ? retval + "Was expecting:" + this.eol + "    " : retval + "Was expecting one of:" + this.eol + "    ";
        retval = retval + expected;
        return retval;
    }

    public int getLineNumber() {
        return this.currentToken != null ? this.currentToken.next.beginLine : this.lineNumber;
    }

    public int getColumnNumber() {
        return this.currentToken != null ? this.currentToken.next.beginColumn : this.columnNumber;
    }

    private String customGetMessage() {
        Token nextToken = this.currentToken.next;
        int kind = nextToken.kind;
        if (kind == 0) {
            StringBuffer buf = new StringBuffer("Unexpected end of file reached.\n");
            block12: for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                int[] sequence = this.expectedTokenSequences[i];
                switch (sequence[0]) {
                    case 34: {
                        buf.append("Unclosed foreach directive.\n");
                        continue block12;
                    }
                    case 32: {
                        buf.append("Unclosed list directive.\n");
                        continue block12;
                    }
                    case 42: {
                        buf.append("Unclosed switch directive.\n");
                        continue block12;
                    }
                    case 31: {
                        buf.append("Unclosed if directive.\n");
                        continue block12;
                    }
                    case 40: {
                        buf.append("Unclosed compress directive.\n");
                        continue block12;
                    }
                    case 39: {
                        buf.append("Unclosed macro directive.\n");
                        continue block12;
                    }
                    case 38: {
                        buf.append("Unclosed function directive.\n");
                        continue block12;
                    }
                    case 41: {
                        buf.append("Unclosed transform directive.\n");
                        continue block12;
                    }
                    case 59: {
                        buf.append("Unclosed escape directive.\n");
                        continue block12;
                    }
                    case 61: {
                        buf.append("Unclosed noescape directive.\n");
                    }
                }
            }
            return buf.toString();
        }
        if (kind == 31 || kind == 9 || kind == 43) {
            return "Found unexpected directive: " + nextToken + " on line " + nextToken.beginLine + ", column " + nextToken.beginColumn + "\nCheck whether you have a well-formed if-else block.";
        }
        return null;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

