/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.interfaces;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jnp.interfaces.MarshalledValuePair;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingEnumerationImpl;
import org.jnp.interfaces.NamingParser;
import org.jnp.interfaces.TimedSocketFactory;

public class NamingContext
implements Context,
Serializable {
    static final long serialVersionUID = 8906455608484282128L;
    public static final String JNP_SOCKET_FACTORY = "jnp.socketFactory";
    public static final String JNP_LOCAL_ADDRESS = "jnp.localAddress";
    public static final String JNP_LOCAL_PORT = "jnp.localPort";
    public static final String JNP_DISABLE_DISCOVERY = "jnp.disableDiscovery";
    public static final String JNP_PARTITION_NAME = "jnp.partitionName";
    public static final String JNP_DISCOVERY_GROUP = "jnp.discoveryGroup";
    public static final String JNP_DISCOVERY_PORT = "jnp.discoveryPort";
    public static final String JNP_DISCOVERY_TTL = "jnp.discoveryTTL";
    public static final String JNP_DISCOVERY_TIMEOUT = "jnp.discoveryTimeout";
    public static final String JNP_PARSED_NAME = "jnp.parsedName";
    public static final String JNP_USE_RELATIVE_NAME = "jnp.useRelativeName";
    public static final String JNP_MAX_RETRIES = "jnp.maxRetries";
    public static final String DEFAULT_DISCOVERY_GROUP_ADDRESS = "230.0.0.4";
    public static final int DEFAULT_DISCOVERY_GROUP_PORT = 1102;
    public static final int DEFAULT_DISCOVERY_TIMEOUT = 5000;
    public static int MAX_RETRIES = 1;
    private static Logger log = Logger.getLogger(NamingContext.class);
    public static Hashtable haServers = new Hashtable();
    public static Naming localServer;
    Naming naming;
    Hashtable env;
    Name prefix;
    NameParser parser = new NamingParser();
    static HashMap cachedServers;

    public static void setHANamingServerForPartition(String partitionName, Naming haServer) {
        haServers.put(partitionName, haServer);
    }

    public static void removeHANamingServerForPartition(String partitionName) {
        haServers.remove(partitionName);
    }

    public static Naming getHANamingServerForPartition(String partitionName) {
        return (Naming)haServers.get(partitionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addServer(String name, Naming server) {
        Class<NamingContext> clazz = NamingContext.class;
        synchronized (NamingContext.class) {
            cachedServers.put(name, new WeakReference<Naming>(server));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static Naming getServer(String host, int port, Hashtable serverEnv) throws NamingException {
        Naming server;
        String hostKey = host + ":" + port;
        WeakReference ref = (WeakReference)cachedServers.get(hostKey);
        if (ref != null && (server = (Naming)ref.get()) != null) {
            return server;
        }
        try {
            Socket s;
            SocketFactory factory = NamingContext.loadSocketFactory(serverEnv);
            try {
                InetAddress localAddr = null;
                int localPort = 0;
                String localAddrStr = (String)serverEnv.get(JNP_LOCAL_ADDRESS);
                String localPortStr = (String)serverEnv.get(JNP_LOCAL_PORT);
                if (localAddrStr != null) {
                    localAddr = InetAddress.getByName(localAddrStr);
                }
                if (localPortStr != null) {
                    localPort = Integer.parseInt(localPortStr);
                }
                s = factory.createSocket(host, port, localAddr, localPort);
            }
            catch (IOException e) {
                ServiceUnavailableException ex = new ServiceUnavailableException("Failed to connect to server " + hostKey);
                ex.setRootCause(e);
                throw ex;
            }
            BufferedInputStream bis = new BufferedInputStream(s.getInputStream());
            ObjectInputStream in = new ObjectInputStream(bis);
            MarshalledObject stub = (MarshalledObject)in.readObject();
            server = (Naming)stub.get();
            s.close();
            NamingContext.addServer(hostKey, server);
            serverEnv.put("hostKey", hostKey);
            return server;
        }
        catch (IOException e) {
            CommunicationException ex = new CommunicationException("Failed to retrieve stub from server " + hostKey);
            ex.setRootCause(e);
            throw ex;
        }
        catch (Exception e) {
            CommunicationException ex = new CommunicationException("Failed to connect to server " + hostKey);
            ex.setRootCause(e);
            throw ex;
        }
    }

    static SocketFactory loadSocketFactory(Hashtable serverEnv) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        SocketFactory factory = null;
        String socketFactoryName = (String)serverEnv.get(JNP_SOCKET_FACTORY);
        if (socketFactoryName == null || socketFactoryName.equals(TimedSocketFactory.class.getName())) {
            factory = new TimedSocketFactory(serverEnv);
            return factory;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> factoryClass = loader.loadClass(socketFactoryName);
        try {
            Class[] ctorSig = new Class[]{Hashtable.class};
            Constructor<?> ctor = factoryClass.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{serverEnv};
            factory = (SocketFactory)ctor.newInstance(ctorArgs);
        }
        catch (NoSuchMethodException e) {
            factory = (SocketFactory)factoryClass.newInstance();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void removeServer(Hashtable serverEnv) {
        String host = "localhost";
        int port = 1099;
        if (serverEnv.get("java.naming.provider.url") == null) return;
        String providerURL = (String)serverEnv.get("java.naming.provider.url");
        StringTokenizer tokenizer = new StringTokenizer(providerURL, ", ");
        while (true) {
            if (!tokenizer.hasMoreElements()) {
                Object hostKey = serverEnv.remove("hostKey");
                if (hostKey == null) return;
                Class<NamingContext> clazz = NamingContext.class;
                // MONITORENTER : org.jnp.interfaces.NamingContext.class
                cachedServers.remove(hostKey);
                // MONITOREXIT : clazz
                return;
            }
            String url = tokenizer.nextToken();
            try {
                int colon;
                Name urlAsName = new NamingParser().parse(url);
                String server = NamingContext.parseNameForScheme(urlAsName, null);
                if (server != null) {
                    url = server;
                }
                if ((colon = url.indexOf(58)) < 0) {
                    host = url.trim();
                } else {
                    host = url.substring(0, colon).trim();
                    try {
                        port = Integer.parseInt(url.substring(colon + 1).trim());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                Class<NamingContext> clazz = NamingContext.class;
                // MONITORENTER : org.jnp.interfaces.NamingContext.class
                cachedServers.remove(host + ":" + port);
                // MONITOREXIT : clazz
            }
            catch (NamingException ignored) {
            }
        }
    }

    static String parseNameForScheme(Name n, Hashtable nameEnv) throws InvalidNameException {
        String serverInfo = null;
        if (n.size() > 0) {
            String scheme = n.get(0);
            int schemeLength = 0;
            if (scheme.startsWith("java:")) {
                schemeLength = 5;
            } else if (scheme.startsWith("jnp:")) {
                schemeLength = 4;
            } else if (scheme.startsWith("jnps:")) {
                schemeLength = 5;
            } else if (scheme.startsWith("jnp-http:")) {
                schemeLength = 9;
            } else if (scheme.startsWith("jnp-https:")) {
                schemeLength = 10;
            }
            if (schemeLength > 0) {
                n = (Name)n.clone();
                String suffix = scheme.substring(schemeLength);
                if (suffix.length() == 0) {
                    n.remove(0);
                    if (n.size() > 1 && n.get(0).equals("")) {
                        serverInfo = n.get(1);
                        n.remove(0);
                        n.remove(0);
                        if (n.size() == 1 && n.get(0).length() == 0) {
                            n.remove(0);
                        }
                    }
                } else {
                    n.remove(0);
                    n.add(0, suffix);
                }
                if (nameEnv != null) {
                    nameEnv.put(JNP_PARSED_NAME, n);
                }
            }
        }
        return serverInfo;
    }

    public static void setLocal(Naming server) {
        localServer = server;
    }

    public NamingContext(Hashtable e, Name baseName, Naming server) throws NamingException {
        this.prefix = baseName == null ? this.parser.parse("") : baseName;
        this.env = e != null ? (Hashtable)e.clone() : new Hashtable();
        this.naming = server;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming server) {
        this.naming = server;
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.getNameParser(name).parse(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        obj = this.getStateToBind(obj, name, refEnv);
        try {
            String className = null;
            if (obj instanceof Referenceable) {
                obj = ((Referenceable)obj).getReference();
            }
            if (!(obj instanceof Reference)) {
                if (obj != null) {
                    className = obj.getClass().getName();
                }
                obj = new MarshalledValuePair(obj);
            } else {
                className = ((Reference)obj).getClassName();
            }
            this.naming.rebind(this.getAbsoluteName(name), obj, className);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            cctx.rebind(cpe.getRemainingName(), obj);
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.getNameParser(name).parse(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        obj = this.getStateToBind(obj, name, refEnv);
        try {
            String className = null;
            if (obj instanceof Referenceable) {
                obj = ((Referenceable)obj).getReference();
            }
            if (!(obj instanceof Reference)) {
                if (obj != null) {
                    className = obj.getClass().getName();
                }
                obj = new MarshalledValuePair(obj);
            } else {
                className = ((Reference)obj).getClassName();
            }
            name = this.getAbsoluteName(name);
            this.naming.bind(name, obj, className);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            cctx.bind(cpe.getRemainingName(), obj);
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this.getNameParser(name).parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        if (name.isEmpty()) {
            return new NamingContext(refEnv, this.prefix, this.naming);
        }
        try {
            Object n;
            int maxTries = 1;
            try {
                n = (String)refEnv.get(JNP_MAX_RETRIES);
                if (n != null) {
                    maxTries = Integer.parseInt((String)n);
                }
                if (maxTries <= 0) {
                    maxTries = 1;
                }
            }
            catch (Exception e) {
                log.debug("Failed to get JNP_MAX_RETRIES, using 1", e);
            }
            n = this.getAbsoluteName(name);
            Object res = null;
            boolean trace = log.isTraceEnabled();
            for (int i = 0; i < maxTries; ++i) {
                try {
                    res = this.naming.lookup((Name)n);
                    break;
                }
                catch (ConnectException ce) {
                    int retries = maxTries - i - 1;
                    if (trace) {
                        log.trace("Connect failed, retry count: " + retries, ce);
                    }
                    if (retries > 0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ignored) {}
                        continue;
                    }
                    throw ce;
                }
            }
            if (res instanceof MarshalledValuePair) {
                MarshalledValuePair mvp = (MarshalledValuePair)res;
                Object storedObj = mvp.get();
                return this.getObjectInstanceWrapFailure(storedObj, name, refEnv);
            }
            if (res instanceof MarshalledObject) {
                MarshalledObject mo = (MarshalledObject)res;
                return mo.get();
            }
            if (res instanceof Context) {
                Enumeration keys = refEnv.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ((Context)res).addToEnvironment(key, refEnv.get(key));
                }
                return res;
            }
            if (res instanceof ResolveResult) {
                Object instanceID;
                Object context;
                ResolveResult rr = (ResolveResult)res;
                Object resolveRes = rr.getResolvedObj();
                if (resolveRes instanceof LinkRef) {
                    context = this.resolveLink(resolveRes, null);
                    instanceID = ((LinkRef)resolveRes).getLinkName();
                } else {
                    instanceID = context = this.getObjectInstanceWrapFailure(resolveRes, name, refEnv);
                }
                if (!(context instanceof Context)) {
                    throw new NotContextException(instanceID + " is not a Context");
                }
                Context ncontext = (Context)context;
                return ncontext.lookup(rr.getRemainingName());
            }
            if (res instanceof LinkRef) {
                res = this.resolveLink(res, refEnv);
            } else if (res instanceof Reference && (res = this.getObjectInstanceWrapFailure(res, name, refEnv)) instanceof LinkRef) {
                res = this.resolveLink(res, refEnv);
            }
            return res;
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.lookup(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.getNameParser(name).parse(name));
    }

    public void unbind(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        try {
            this.naming.unbind(this.getAbsoluteName(name));
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            cctx.unbind(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public void rename(String oldname, String newname) throws NamingException {
        this.rename(this.getNameParser(oldname).parse(oldname), this.getNameParser(newname).parse(newname));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        try {
            return new NamingEnumerationImpl(this.naming.list(this.getAbsoluteName(name)));
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.list(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        try {
            Collection bindings = this.naming.listBindings(this.getAbsoluteName(name));
            ArrayList<Binding> realBindings = new ArrayList<Binding>(bindings.size());
            for (Binding binding : bindings) {
                Object obj = binding.getObject();
                if (obj instanceof MarshalledValuePair) {
                    try {
                        obj = ((MarshalledValuePair)obj).get();
                    }
                    catch (ClassNotFoundException e) {
                        CommunicationException ex = new CommunicationException();
                        ex.setRootCause(e);
                        throw ex;
                    }
                }
                if (obj instanceof MarshalledObject) {
                    try {
                        obj = ((MarshalledObject)obj).get();
                    }
                    catch (ClassNotFoundException e) {
                        CommunicationException ex = new CommunicationException();
                        ex.setRootCause(e);
                        throw ex;
                    }
                }
                realBindings.add(new Binding(binding.getName(), binding.getClassName(), obj));
            }
            return new NamingEnumerationImpl(realBindings);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.listBindings(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(this.parser.parse(name), this.parser.parse(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser(name).parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        try {
            name = this.getAbsoluteName(name);
            return this.naming.createSubcontext(name);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.createSubcontext(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object old = this.env.get(propName);
        this.env.put(propName, propVal);
        return old;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env = null;
        this.naming = null;
    }

    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.getNameParser(name).parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.lookup(name);
        }
        Object link = null;
        try {
            Name n = this.getAbsoluteName(name);
            link = this.naming.lookup(n);
            if (!(link instanceof LinkRef) && link instanceof Reference) {
                link = this.getObjectInstance(link, name, null);
            }
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(this.env);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Could not lookup link");
            ex.setRemainingName(name);
            ex.setRootCause(e);
            throw ex;
        }
        return link;
    }

    protected Object resolveLink(Object res, Hashtable refEnv) throws NamingException {
        Object linkResult = null;
        try {
            LinkRef link = (LinkRef)res;
            String ref = link.getLinkName();
            linkResult = ref.startsWith("./") ? this.lookup(ref.substring(2)) : (refEnv != null ? new InitialContext(refEnv).lookup(ref) : new InitialContext().lookup(ref));
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Could not dereference object");
            ex.setRootCause(e);
            throw ex;
        }
        return linkResult;
    }

    private boolean useAbsoluteName(Hashtable env) {
        if (env == null) {
            return true;
        }
        String useRelativeName = (String)env.get(JNP_USE_RELATIVE_NAME);
        return Boolean.valueOf(useRelativeName) == Boolean.FALSE;
    }

    private Object getStateToBind(Object obj, Name name, Hashtable env) throws NamingException {
        if (this.useAbsoluteName(env)) {
            name = this.getAbsoluteName(name);
        }
        return NamingManager.getStateToBind(obj, name, this, env);
    }

    private Object getObjectInstance(Object obj, Name name, Hashtable env) throws Exception {
        if (this.useAbsoluteName(env)) {
            name = this.getAbsoluteName(name);
        }
        return NamingManager.getObjectInstance(obj, name, this, env);
    }

    private Object getObjectInstanceWrapFailure(Object obj, Name name, Hashtable env) throws NamingException {
        try {
            return this.getObjectInstance(obj, name, env);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Could not dereference object");
            ex.setRootCause(e);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Naming discoverServer(Hashtable serverEnv) throws NamingException {
        Naming naming;
        boolean trace = log.isTraceEnabled();
        String disableDiscovery = (String)serverEnv.get(JNP_DISABLE_DISCOVERY);
        if (Boolean.valueOf(disableDiscovery) == Boolean.TRUE) {
            if (!trace) return null;
            log.trace("Skipping discovery due to disable flag");
            return null;
        }
        String partitionName = (String)serverEnv.get(JNP_PARTITION_NAME);
        Naming server = null;
        if (partitionName != null && (server = NamingContext.getHANamingServerForPartition(partitionName)) != null) {
            return server;
        }
        MulticastSocket s = null;
        InetAddress iaGroup = null;
        try {
            String discoveryGroupPort;
            String discoveryTimeout;
            String discoveryGroup;
            String group = DEFAULT_DISCOVERY_GROUP_ADDRESS;
            int port = 1102;
            int timeout = 5000;
            int ttl = 16;
            String discoveryTTL = (String)serverEnv.get(JNP_DISCOVERY_TTL);
            if (discoveryTTL != null) {
                ttl = Integer.parseInt(discoveryTTL);
            }
            if ((discoveryGroup = (String)serverEnv.get(JNP_DISCOVERY_GROUP)) != null) {
                group = discoveryGroup;
            }
            if ((discoveryTimeout = (String)serverEnv.get(JNP_DISCOVERY_TIMEOUT)) == null) {
                discoveryTimeout = (String)serverEnv.get("DISCOVERY_TIMEOUT");
            }
            if (discoveryTimeout != null && !discoveryTimeout.equals("")) {
                timeout = Integer.parseInt(discoveryTimeout);
            }
            if ((discoveryGroupPort = (String)serverEnv.get(JNP_DISCOVERY_PORT)) == null) {
                discoveryGroupPort = (String)serverEnv.get("DISCOVERY_GROUP");
            }
            if (discoveryGroupPort != null && !discoveryGroupPort.equals("")) {
                int colon = discoveryGroupPort.indexOf(58);
                if (colon < 0) {
                    try {
                        port = Integer.parseInt(discoveryGroupPort);
                    }
                    catch (Exception ex) {
                        log.warn("Failed to parse port: " + discoveryGroupPort, ex);
                    }
                } else {
                    group = discoveryGroupPort.substring(0, colon);
                    String portStr = discoveryGroupPort.substring(colon + 1);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (Exception ex) {
                        log.warn("Failed to parse port: " + portStr, ex);
                    }
                }
            }
            iaGroup = InetAddress.getByName(group);
            String localAddrStr = (String)serverEnv.get(JNP_LOCAL_ADDRESS);
            String localPortStr = (String)serverEnv.get(JNP_LOCAL_PORT);
            int localPort = 0;
            if (localPortStr != null) {
                localPort = Integer.parseInt(localPortStr);
            }
            if (localAddrStr != null) {
                InetSocketAddress localAddr = new InetSocketAddress(localAddrStr, localPort);
                s = new MulticastSocket(localAddr);
            } else {
                s = new MulticastSocket(localPort);
            }
            s.setSoTimeout(timeout);
            s.setTimeToLive(ttl);
            if (log.isTraceEnabled()) {
                log.trace("TTL on multicast discovery socket is " + ttl);
            }
            s.joinGroup(iaGroup);
            if (trace) {
                log.trace("MulticastSocket: " + s);
            }
            StringBuffer data = new StringBuffer("GET_ADDRESS");
            if (partitionName != null) {
                data.append(":" + partitionName);
            }
            byte[] buf = data.toString().getBytes();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, iaGroup, port);
            if (trace) {
                log.trace("Sending discovery packet(" + data + ") to: " + iaGroup + ":" + port);
            }
            s.send(packet);
            buf = new byte[50];
            packet = new DatagramPacket(buf, buf.length);
            s.receive(packet);
            String myServer = new String(packet.getData()).trim();
            if (trace) {
                log.trace("Received answer packet: " + myServer);
            }
            while (myServer != null && myServer.startsWith("GET_ADDRESS")) {
                Arrays.fill(buf, (byte)0);
                packet.setLength(buf.length);
                s.receive(packet);
                byte[] reply = packet.getData();
                myServer = new String(reply).trim();
                if (!trace) continue;
                log.trace("Received answer packet: " + myServer);
            }
            int colon = myServer.indexOf(58);
            if (colon >= 0) {
                String serverHost = myServer.substring(0, colon);
                int serverPort = Integer.valueOf(myServer.substring(colon + 1));
                server = NamingContext.getServer(serverHost, serverPort, serverEnv);
            }
            naming = server;
        }
        catch (IOException e) {
            try {
                if (trace) {
                    log.trace("Discovery failed", e);
                }
                CommunicationException ex = new CommunicationException(e.getMessage());
                ex.setRootCause(e);
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        s.leaveGroup(iaGroup);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (s == null) throw throwable;
                    s.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (s != null) {
                s.leaveGroup(iaGroup);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            if (s == null) return naming;
            s.close();
            return naming;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return naming;
    }

    private void checkRef(Hashtable refEnv) throws NamingException {
        if (this.naming == null) {
            String host = "localhost";
            int port = 1099;
            Exception serverEx = null;
            String urls = (String)refEnv.get("java.naming.provider.url");
            if (urls != null && urls.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(urls, ",");
                while (this.naming == null && tokenizer.hasMoreElements()) {
                    int colon;
                    String url = tokenizer.nextToken();
                    Name urlAsName = this.getNameParser("").parse(url);
                    String server = NamingContext.parseNameForScheme(urlAsName, null);
                    if (server != null) {
                        url = server;
                    }
                    if ((colon = url.indexOf(58)) < 0) {
                        host = url;
                    } else {
                        host = url.substring(0, colon).trim();
                        try {
                            port = Integer.parseInt(url.substring(colon + 1).trim());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        this.naming = NamingContext.getServer(host, port, refEnv);
                    }
                    catch (Exception e) {
                        serverEx = e;
                        log.debug("Failed to connect to " + host + ":" + port, e);
                    }
                }
                Exception discoveryFailure = null;
                if (this.naming == null) {
                    block21: {
                        try {
                            this.naming = this.discoverServer(refEnv);
                        }
                        catch (Exception e) {
                            discoveryFailure = e;
                            if (serverEx != null) break block21;
                            serverEx = e;
                        }
                    }
                    if (this.naming == null) {
                        StringBuffer buffer = new StringBuffer(50);
                        buffer.append("Could not obtain connection to any of these urls: ").append(urls);
                        if (discoveryFailure != null) {
                            buffer.append(" and discovery failed with error: ").append(discoveryFailure);
                        }
                        CommunicationException ce = new CommunicationException(buffer.toString());
                        ce.setRootCause(serverEx);
                        throw ce;
                    }
                }
            } else {
                String jnpPartitionName = (String)refEnv.get(JNP_PARTITION_NAME);
                if (jnpPartitionName != null) {
                    this.naming = this.discoverServer(refEnv);
                    if (this.naming == null) {
                        throw new ConfigurationException("No valid context could be build for jnp.partitionName=" + jnpPartitionName);
                    }
                } else {
                    this.naming = localServer;
                    if (this.naming == null) {
                        this.naming = this.discoverServer(refEnv);
                        if (this.naming == null) {
                            throw new ConfigurationException("No valid Context.PROVIDER_URL was found");
                        }
                    }
                }
            }
        }
    }

    private Name getAbsoluteName(Name n) throws NamingException {
        if (n.isEmpty()) {
            return this.composeName(n, this.prefix);
        }
        if (n.get(0).toString().equals("")) {
            return n.getSuffix(1);
        }
        return this.composeName(n, this.prefix);
    }

    private Hashtable getEnv(Name n) throws InvalidNameException {
        Hashtable nameEnv = this.env;
        this.env.remove(JNP_PARSED_NAME);
        String serverInfo = NamingContext.parseNameForScheme(n, nameEnv);
        if (serverInfo != null) {
            nameEnv = (Hashtable)this.env.clone();
            nameEnv.put("java.naming.provider.url", serverInfo);
        }
        return nameEnv;
    }

    static {
        cachedServers = new HashMap();
    }
}

