/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.sound;

import com.octo.captcha.Captcha;
import com.octo.captcha.CaptchaException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public abstract class SoundCaptcha
implements Captcha {
    protected Boolean hasChallengeBeenCalled = Boolean.FALSE;
    protected String question;
    protected transient AudioInputStream challenge;

    protected SoundCaptcha(String thequestion, AudioInputStream thechallenge) {
        this.question = thequestion;
        this.challenge = thechallenge;
    }

    public final String getQuestion() {
        return this.question;
    }

    public final Object getChallenge() {
        return this.getSoundChallenge();
    }

    public final AudioInputStream getSoundChallenge() {
        this.hasChallengeBeenCalled = Boolean.TRUE;
        return this.challenge;
    }

    public void disposeChallenge() {
        this.challenge = null;
    }

    public Boolean hasGetChalengeBeenCalled() {
        return this.hasChallengeBeenCalled;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.challenge != null) {
            out.defaultWriteObject();
            AudioSystem.write(this.challenge, AudioFileFormat.Type.WAVE, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.challenge = AudioSystem.getAudioInputStream(in);
        }
        catch (UnsupportedAudioFileException e) {
            throw new CaptchaException("unable to deserialize input stream", e);
        }
    }
}

