/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.lib.StringUtil;

class Like {
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    Character escapeChar;
    boolean hasCollation;
    boolean optimised;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;

    Like(Character c, boolean bl) {
        this.escapeChar = c;
        this.hasCollation = bl;
    }

    void setParams(Session session, String string, boolean bl) {
        this.isIgnoreCase = bl;
        this.normalize(session, string);
        this.optimised = true;
    }

    void resetPattern(Session session, String string) {
        this.normalize(session, string);
    }

    private String getStartsWith() {
        int n;
        if (this.iLen == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.iLen && this.wildCardType[n] == 0; ++n) {
            stringBuffer.append(this.cLike[n]);
        }
        if (n == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    Boolean compare(Session session, String string) {
        if (string == null) {
            return null;
        }
        if (this.isIgnoreCase) {
            string = session.database.collation.toUpperCase(string);
        }
        return this.compareAt(string, 0, 0, string.length()) ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean compareAt(String string, int n, int n2, int n3) {
        while (n < this.iLen) {
            switch (this.wildCardType[n]) {
                case 0: {
                    if (n2 < n3 && this.cLike[n] == string.charAt(n2++)) break;
                    return false;
                }
                case 1: {
                    if (n2++ < n3) break;
                    return false;
                }
                case 2: {
                    if (++n >= this.iLen) {
                        return true;
                    }
                    while (n2 < n3) {
                        if (this.cLike[n] == string.charAt(n2) && this.compareAt(string, n, n2, n3)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            }
            ++n;
        }
        return n2 == n3;
    }

    private void normalize(Session session, String string) {
        int n;
        boolean bl = this.isNull = string == null;
        if (!this.isNull && this.isIgnoreCase) {
            string = session.database.collation.toUpperCase(string);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        int n2 = string == null ? 0 : string.length();
        this.cLike = new char[n2];
        this.wildCardType = new int[n2];
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (!bl2) {
                if (this.escapeChar != null && this.escapeChar.charValue() == c) {
                    bl2 = true;
                    continue;
                }
                if (c == '_') {
                    this.wildCardType[this.iLen] = 1;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else if (c == '%') {
                    if (bl3) continue;
                    bl3 = true;
                    this.wildCardType[this.iLen] = 2;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = false;
                bl2 = false;
            }
            this.cLike[this.iLen++] = c;
        }
        for (n = 0; n < this.iLen - 1; ++n) {
            if (this.wildCardType[n] != 2 || this.wildCardType[n + 1] != 1) continue;
            this.wildCardType[n] = 1;
            this.wildCardType[n + 1] = 2;
        }
    }

    boolean hasWildcards() {
        return this.iFirstWildCard != -1;
    }

    boolean isEquivalentToFalsePredicate() {
        return this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isNull || !this.hasWildcards()) {
            return false;
        }
        for (int i = 0; i < this.wildCardType.length; ++i) {
            if (this.wildCardType[i] == 2) continue;
            return false;
        }
        return true;
    }

    boolean isEquivalentToBetweenPredicate() {
        return this.iFirstWildCard > 0 && this.iFirstWildCard == this.wildCardType.length - 1 && this.cLike[this.iFirstWildCard] == '%';
    }

    boolean isEquivalentToBetweenPredicateAugmentedWithLike() {
        return this.iFirstWildCard > 0 && this.cLike[this.iFirstWildCard] == '%';
    }

    String getRangeLow() {
        return this.getStartsWith();
    }

    String getRangeHigh() {
        String string = this.getStartsWith();
        return string == null ? null : string.concat("\uffff");
    }

    public String describe(Session session) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        stringBuffer.append("escapeChar=").append(this.escapeChar).append('\n');
        stringBuffer.append("isNull=").append(this.isNull).append('\n');
        stringBuffer.append("optimised=").append(this.optimised).append('\n');
        stringBuffer.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
        stringBuffer.append("iLen=").append(this.iLen).append('\n');
        stringBuffer.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
        stringBuffer.append("cLike=");
        stringBuffer.append(StringUtil.arrayToString(this.cLike));
        stringBuffer.append('\n');
        stringBuffer.append("wildCardType=");
        stringBuffer.append(StringUtil.arrayToString(this.wildCardType));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

