/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.seam.web.MultipartRequest;

public class UIFileUpload
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.jboss.seam.ui.UIFileUpload";
    public static final String COMPONENT_FAMILY = "org.jboss.seam.ui.FileUpload";
    private static final String TOMAHAWK_WRAPPER_CLASS = "org.apache.myfaces.webapp.filter.MultipartRequestWrapper";
    private String accept;
    private String required;
    private String disabled;
    private String styleClass;
    private String style;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(FacesContext context) {
        super.decode(context);
        Object request = context.getExternalContext().getRequest();
        if (!(request instanceof MultipartRequest) && request instanceof HttpServletRequestWrapper) {
            request = ((HttpServletRequestWrapper)request).getRequest();
        }
        if (!(request instanceof MultipartRequest) && request.getClass().getName().equals(TOMAHAWK_WRAPPER_CLASS)) {
            Field f = null;
            try {
                f = request.getClass().getDeclaredField("request");
                f.setAccessible(true);
                request = f.get(request);
            }
            catch (Exception ex) {
            }
            finally {
                if (f != null) {
                    f.setAccessible(false);
                }
            }
        }
        if (request instanceof MultipartRequest) {
            ValueBinding vb;
            MultipartRequest req = (MultipartRequest)request;
            String clientId = this.getClientId(context);
            String contentType = req.getFileContentType(clientId);
            String fileName = req.getFileName(clientId);
            int fileSize = req.getFileSize(clientId);
            ValueBinding dataBinding = this.getValueBinding("data");
            if (dataBinding != null) {
                Class cls = dataBinding.getType(context);
                if (cls.isAssignableFrom(InputStream.class)) {
                    dataBinding.setValue(context, (Object)req.getFileInputStream(clientId));
                } else if (cls.isAssignableFrom(byte[].class)) {
                    dataBinding.setValue(context, (Object)req.getFileBytes(clientId));
                }
            }
            if ((vb = this.getValueBinding("contentType")) != null) {
                vb.setValue(context, (Object)contentType);
            }
            if ((vb = this.getValueBinding("fileName")) != null) {
                vb.setValue(context, (Object)fileName);
            }
            if ((vb = this.getValueBinding("fileSize")) != null) {
                vb.setValue(context, (Object)fileSize);
            }
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)this);
        writer.writeAttribute("type", (Object)"file", null);
        String clientId = this.getClientId(context);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        ValueBinding vb = this.getValueBinding("accept");
        if (vb != null) {
            writer.writeAttribute("accept", vb.getValue(context), null);
        } else if (this.accept != null) {
            writer.writeAttribute("accept", (Object)this.accept, null);
        }
        writer.endElement("input");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getDisabled() {
        return this.disabled;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}

