/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionListener;
import javax.faces.model.DataModel;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Pages;
import org.jboss.seam.ui.HTML;
import org.jboss.seam.ui.UIAction;
import org.jboss.seam.ui.UIConversationId;
import org.jboss.seam.ui.UIConversationIsLongRunning;
import org.jboss.seam.ui.UIConversationPropagation;
import org.jboss.seam.ui.UISelection;
import org.jboss.seam.ui.UITaskId;

public class HtmlLink
extends HtmlOutputLink
implements ActionSource {
    public static final String COMPONENT_TYPE = "org.jboss.seam.ui.HtmlLink";
    private String view;
    private MethodBinding action;
    private String pageflow;
    private String propagation = "default";
    private String fragment;
    private boolean disabled;
    private String outcome;

    private UISelection getSelection() {
        UIData parentUIData = this.getParentUIData();
        if (parentUIData != null) {
            if (parentUIData.getValue() instanceof DataModel) {
                String dataModelExpression = parentUIData.getValueBinding("value").getExpressionString();
                String dataModelName = dataModelExpression.substring(2, dataModelExpression.length() - 1).replace('$', '.');
                UISelection uiSelection = new UISelection();
                uiSelection.setDataModel(dataModelName);
                uiSelection.setVar(parentUIData.getVar());
                return uiSelection;
            }
            return null;
        }
        return null;
    }

    public UIData getParentUIData() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            return (UIData)parent;
        }
        return null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UISelection uiSelection;
        ValueBinding taskInstanceValueBinding;
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", (UIComponent)this);
        writer.writeAttribute("id", (Object)this.getClientId(context), "id");
        ValueBinding viewBinding = this.getValueBinding("view");
        String viewId = viewBinding != null ? (String)viewBinding.getValue(context) : (this.view != null ? this.view : context.getViewRoot().getViewId());
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        String encodedUrl = context.getExternalContext().encodeActionURL(url);
        encodedUrl = Pages.instance().encodeScheme(viewId, context, encodedUrl);
        String characterEncoding = context.getResponseWriter().getCharacterEncoding();
        boolean first = true;
        HashSet<String> usedParameters = new HashSet<String>();
        for (Object child : this.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter uip = (UIParameter)child;
            if (uip.getValue() != null) {
                encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uip, first);
                first = false;
            }
            usedParameters.add(uip.getName());
        }
        if (viewId != null) {
            Map pageParameters = Pages.instance().getConvertedParameters(context, viewId, usedParameters);
            for (Map.Entry me : pageParameters.entrySet()) {
                UIParameter uip = new UIParameter();
                uip.setName((String)me.getKey());
                uip.setValue(me.getValue());
                encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uip, first);
                first = false;
            }
        }
        if (this.action != null || this.outcome != null) {
            UIAction uiAction = new UIAction();
            uiAction.setAction(this.action == null ? this.outcome : this.action.getExpressionString());
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiAction, first);
            first = false;
        }
        if ("default".equals(this.propagation) || "join".equals(this.propagation) || "nest".equals(this.propagation) || "end".equals(this.propagation)) {
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, new UIConversationId(), first);
            first = false;
            if (Conversation.instance().isLongRunning() || Conversation.instance().isNested()) {
                encodedUrl = encodedUrl + this.getParameterString(characterEncoding, new UIConversationIsLongRunning(), first);
            }
        }
        if ("join".equals(this.propagation) || "nest".equals(this.propagation) || "begin".equals(this.propagation) || "end".equals(this.propagation)) {
            UIConversationPropagation uiPropagation = new UIConversationPropagation();
            uiPropagation.setType(this.propagation);
            uiPropagation.setPageflow(this.pageflow);
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiPropagation, first);
            first = false;
        }
        if ((taskInstanceValueBinding = this.getValueBinding("taskInstance")) != null) {
            UITaskId uiTaskId = new UITaskId();
            uiTaskId.setValueBinding("taskInstance", taskInstanceValueBinding);
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiTaskId, first);
            first = false;
        }
        if ((uiSelection = this.getSelection()) != null) {
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiSelection, first);
            first = false;
        }
        if (this.fragment != null) {
            encodedUrl = encodedUrl + '#' + this.fragment;
        }
        if (!this.isDisabled(context)) {
            writer.writeAttribute("href", (Object)encodedUrl, null);
        }
        HTML.renderHTMLAttributes(writer, (UIComponent)this, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
        Object label = this.getValue();
        writer.flush();
        if (label != null) {
            writer.writeText(label, null);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        context.getResponseWriter().endElement("a");
    }

    private String getParameterString(String characterEncoding, UIParameter param, boolean first) throws UnsupportedEncodingException {
        Object value = param.getValue();
        String strValue = value == null ? "" : value.toString();
        String encoded = characterEncoding == null ? URLEncoder.encode(strValue) : URLEncoder.encode(strValue, characterEncoding);
        return (first ? (char)'?' : '&') + param.getName() + '=' + encoded;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String viewId) {
        this.view = viewId;
    }

    private boolean isDisabled(FacesContext facesContext) {
        ValueBinding disabledValueBinding = this.getValueBinding("disabled");
        return disabledValueBinding == null ? this.disabled : (Boolean)disabledValueBinding.getValue(facesContext);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.view = (String)values[1];
        this.pageflow = (String)values[2];
        this.propagation = (String)values[3];
        this.action = (MethodBinding)HtmlLink.restoreAttachedState((FacesContext)context, (Object)values[4]);
        this.disabled = (Boolean)values[5];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.view, this.pageflow, this.propagation, HtmlLink.saveAttachedState((FacesContext)context, (Object)this.action), this.disabled};
        return values;
    }

    public String getPageflow() {
        return this.pageflow;
    }

    public String getPropagation() {
        return this.propagation;
    }

    public void setPageflow(String pageflow) {
        this.pageflow = pageflow;
    }

    public void setPropagation(String propagation) {
        this.propagation = propagation;
    }

    public MethodBinding getAction() {
        return this.action;
    }

    public void setAction(MethodBinding action) {
        this.action = action;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void addActionListener(ActionListener listener) {
    }

    public MethodBinding getActionListener() {
        return null;
    }

    public ActionListener[] getActionListeners() {
        return null;
    }

    public boolean isImmediate() {
        return false;
    }

    public void setImmediate(boolean immediate) {
    }

    public void removeActionListener(ActionListener listener) {
    }

    public void setActionListener(MethodBinding actionListener) {
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }
}

