/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadBundleTag
extends TagSupport {
    private static final long serialVersionUID = -8892145684062838928L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$taglib$core$LoadBundleTag == null ? (class$org$apache$myfaces$taglib$core$LoadBundleTag = LoadBundleTag.class$("org.apache.myfaces.taglib.core.LoadBundleTag")) : class$org$apache$myfaces$taglib$core$LoadBundleTag));
    private String _basename;
    private String _var;
    static /* synthetic */ Class class$org$apache$myfaces$taglib$core$LoadBundleTag;

    public void setBasename(String basename) {
        this._basename = basename;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public int doStartTag() throws JspException {
        ResourceBundle bundle;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new JspException("No faces context?!");
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            throw new JspException("No view root! LoadBundle must be nested inside <f:view> action.");
        }
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            locale = facesContext.getApplication().getDefaultLocale();
        }
        String basename = null;
        if (this._basename != null) {
            basename = UIComponentTag.isValueReference((String)this._basename) ? (String)facesContext.getApplication().createValueBinding(this._basename).getValue(facesContext) : this._basename;
        }
        try {
            bundle = ResourceBundle.getBundle(basename, locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException e) {
            log.error((Object)("Resource bundle '" + basename + "' could not be found."));
            return 0;
        }
        facesContext.getExternalContext().getRequestMap().put(this._var, new BundleMap(bundle));
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BundleMap
    implements Map {
        private ResourceBundle _bundle;
        private List _values;

        public BundleMap(ResourceBundle bundle) {
            this._bundle = bundle;
        }

        public Object get(Object key) {
            try {
                return this._bundle.getObject(key.toString());
            }
            catch (Exception e) {
                return "MISSING: " + key + " :MISSING";
            }
        }

        public boolean isEmpty() {
            return !this._bundle.getKeys().hasMoreElements();
        }

        public boolean containsKey(Object key) {
            try {
                return this._bundle.getObject(key.toString()) != null;
            }
            catch (MissingResourceException e) {
                return false;
            }
        }

        public Collection values() {
            if (this._values == null) {
                this._values = new ArrayList();
                Enumeration<String> enumer = this._bundle.getKeys();
                while (enumer.hasMoreElements()) {
                    String v = this._bundle.getString(enumer.nextElement());
                    this._values.add(v);
                }
            }
            return this._values;
        }

        public int size() {
            return this.values().size();
        }

        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        public Set entrySet() {
            HashSet<1> set = new HashSet<1>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                final String k = enumer.nextElement();
                set.add(new Map.Entry(){

                    public Object getKey() {
                        return k;
                    }

                    public Object getValue() {
                        return BundleMap.this._bundle.getObject(k);
                    }

                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
                    }
                });
            }
            return set;
        }

        public Set keySet() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                set.add(enumer.nextElement());
            }
            return set;
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public void clear() {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    }
}

