/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom.serialize;

import java.io.IOException;
import java.io.Writer;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.serialize.AbstractSerializationUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultSerializationUnit
extends AbstractSerializationUnit {
    private boolean closeEmptyElements = false;

    public DefaultSerializationUnit(SmooksResourceConfiguration resourceConfig) {
        super(resourceConfig);
        this.closeEmptyElements = resourceConfig.getBoolParameter("closeEmptyElements", false);
    }

    public void writeElementStart(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write(60);
        writer.write(element.getTagName());
        this.writeAttributes(element.getAttributes(), writer);
        if (!this.closeEmptyElements || element.hasChildNodes()) {
            writer.write(62);
        }
    }

    protected void writeAttributes(NamedNodeMap attributes, Writer writer) throws IOException {
        int attribCount = attributes.getLength();
        for (int i = 0; i < attribCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attribValue = attribute.getValue();
            int enclosingChar = 34;
            writer.write(32);
            writer.write(attribute.getName());
            writer.write(61);
            if (attribValue.indexOf(34) != -1) {
                enclosingChar = 39;
            }
            writer.write(enclosingChar);
            writer.write(attribValue);
            writer.write(enclosingChar);
        }
    }

    public void writeElementEnd(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        if (this.closeEmptyElements && !element.hasChildNodes()) {
            writer.write("/>");
        } else {
            writer.write("</");
            writer.write(element.getTagName());
            writer.write(62);
        }
    }

    public void writeElementText(Text text, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write(text.getData());
    }

    public void writeElementComment(Comment comment, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write("<!--");
        writer.write(comment.getData());
        writer.write("-->");
    }

    public void writeElementEntityRef(EntityReference entityRef, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write(38);
        writer.write(entityRef.getNodeName());
        writer.write(59);
    }

    public void writeElementCDATA(CDATASection cdata, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write("<![CDATA[");
        writer.write(cdata.getData());
        writer.write("]]>");
    }

    public void writeElementNode(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
        throw new IOException("writeElementNode not implemented yet. Node: " + node.getNodeValue() + ", node: [" + node + "]");
    }

    public boolean writeChildElements() {
        return true;
    }
}

