/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.milyn.cdr.ParameterDecodeException;
import org.milyn.cdr.ParameterDecoder;
import org.milyn.cdr.SmooksResourceConfiguration;

public class TokenizedStringParameterDecoder
extends ParameterDecoder {
    Class returnType;
    String delims;
    boolean returnDelims;
    boolean trimTokens;

    public TokenizedStringParameterDecoder(SmooksResourceConfiguration resourceConfig) {
        super(resourceConfig);
        this.delims = resourceConfig.getStringParameter("delims", ",");
        this.returnDelims = resourceConfig.getBoolParameter("returnDelims", false);
        this.trimTokens = resourceConfig.getBoolParameter("trimTokens", true);
        String paramType = resourceConfig.getStringParameter("param-type:", "string-list");
        if (paramType.equals("string-list")) {
            this.returnType = Vector.class;
        } else if (paramType.equals("string-hashset")) {
            this.returnType = LinkedHashSet.class;
        } else {
            throw new ParameterDecodeException("Unsupported decoded return type [" + paramType + "]");
        }
    }

    public Object decodeValue(String value) throws ParameterDecodeException {
        Collection returnVal = null;
        try {
            returnVal = (Collection)this.returnType.newInstance();
        }
        catch (Exception e) {
            IllegalStateException state = new IllegalStateException("Unable to construct Collection instance.");
            state.initCause(e);
            throw state;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, this.delims, this.returnDelims);
        while (tokenizer.hasMoreTokens()) {
            if (this.trimTokens) {
                returnVal.add(tokenizer.nextToken().trim());
                continue;
            }
            returnVal.add(tokenizer.nextToken());
        }
        return returnVal;
    }
}

