/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.ClasspathUtils;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.ProfileTargetingExpression;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.io.StreamUtils;
import org.milyn.resource.URIResourceLocator;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SmooksResourceConfiguration {
    private static Log logger = LogFactory.getLog(SmooksResourceConfiguration.class);
    private String selector;
    private String[] contextualSelector;
    private String[] profileTargetingExpressionStrings;
    private ProfileTargetingExpression[] profileTargetingExpressions;
    private String resource;
    private String resourceType;
    public static final String PARAM_RESTYPE = "restype";
    public static final String PARAM_RESDATA = "resdata";
    public static final String XML_DEF_PREFIX = "xmldef:".toLowerCase();
    private boolean isXmlDef;
    private HashMap<String, Object> parameters;
    private int parameterCount;
    private String namespaceURI;
    private static URIResourceLocator uriResourceLocator = new URIResourceLocator();
    public static final String DOCUMENT_FRAGMENT_SELECTOR = "$document";

    public SmooksResourceConfiguration() {
        this.setSelector("none");
        this.setTargetProfile("*");
    }

    public SmooksResourceConfiguration(String selector) {
        this.setSelector(selector);
    }

    public SmooksResourceConfiguration(String selector, String resource) {
        this(selector, "*", resource);
    }

    public SmooksResourceConfiguration(String selector, String targetProfile, String resource) {
        this(selector);
        this.setTargetProfile(targetProfile);
        this.setResource(resource);
    }

    public SmooksResourceConfiguration(String selector, String selectorNamespaceURI, String targetProfile, String resource) {
        this(selector, targetProfile, resource);
        this.setSelectorNamespaceURI(selectorNamespaceURI);
    }

    public void setSelector(String selector) {
        if (selector == null || selector.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'selector' arg in constructor call.");
        }
        this.selector = selector.toLowerCase().intern();
        this.isXmlDef = selector.startsWith(XML_DEF_PREFIX);
        this.contextualSelector = this.selector.split(" +");
    }

    public void setSelectorNamespaceURI(String namespaceURI) {
        if (namespaceURI != null) {
            this.namespaceURI = namespaceURI.equals("*") ? null : namespaceURI.intern();
        }
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setTargetProfile(String targetProfile) {
        if (targetProfile == null || targetProfile.trim().equals("")) {
            targetProfile = "*";
        }
        this.parseTargetingExpressions(targetProfile);
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getSelector() {
        return this.selector;
    }

    public String[] getContextualSelector() {
        return this.contextualSelector;
    }

    public String getTargetElement() {
        if (this.contextualSelector != null) {
            return this.contextualSelector[this.contextualSelector.length - 1];
        }
        return null;
    }

    public String getSelectorNamespaceURI() {
        return this.namespaceURI;
    }

    public ProfileTargetingExpression[] getProfileTargetingExpressions() {
        return this.profileTargetingExpressions;
    }

    public String getResource() {
        return this.resource;
    }

    public String getResourceType() {
        if (this.isJavaResource()) {
            return "class";
        }
        String restype = this.getStringParameter(PARAM_RESTYPE);
        if (restype != null && !restype.trim().equals("")) {
            if (this.getParameter(PARAM_RESDATA) == null) {
                logger.warn((Object)"Resource configuration defined with 'restype' parameter but no 'resdata' parameter.");
            }
        } else {
            restype = this.resourceType != null ? this.resourceType : this.getExtension(this.getResource());
        }
        return restype;
    }

    private void parseTargetingExpressions(String targetProfiles) {
        StringTokenizer tokenizer = new StringTokenizer(targetProfiles.toLowerCase(), ",|;");
        if (tokenizer.countTokens() == 0) {
            throw new IllegalArgumentException("Empty 'target-profile'. [" + this.selector + "][" + this.resource + "]");
        }
        this.profileTargetingExpressionStrings = new String[tokenizer.countTokens()];
        this.profileTargetingExpressions = new ProfileTargetingExpression[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String expression;
            this.profileTargetingExpressionStrings[i] = expression = tokenizer.nextToken();
            this.profileTargetingExpressions[i] = new ProfileTargetingExpression(expression);
            ++i;
        }
    }

    private String getExtension(String path) {
        int extensionIndex;
        File resFile;
        String resName;
        if (path != null && (resName = (resFile = new File(path)).getName()) != null && !resName.trim().equals("") && (extensionIndex = resName.lastIndexOf(46)) != -1 && extensionIndex + 1 < resName.length()) {
            return resName.substring(extensionIndex + 1);
        }
        return null;
    }

    public Parameter setParameter(String name, String value) {
        Parameter param = new Parameter(name, value);
        this.setParameter(param);
        return param;
    }

    public Parameter setParameter(String name, String type, String value) {
        Parameter param = new Parameter(name, value, type);
        this.setParameter(param);
        return param;
    }

    public void setParameter(Parameter parameter) {
        Object exists;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        if ((exists = this.parameters.get(parameter.getName())) == null) {
            this.parameters.put(parameter.getName(), parameter);
        } else if (exists instanceof Parameter) {
            Vector<Parameter> paramList = new Vector<Parameter>();
            paramList.add((Parameter)exists);
            paramList.add(parameter);
            this.parameters.put(parameter.getName(), paramList);
        } else if (exists instanceof List) {
            ((List)exists).add(parameter);
        }
        ++this.parameterCount;
    }

    public Parameter getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (Parameter)((List)parameter).get(0);
        }
        if (parameter instanceof Parameter) {
            return (Parameter)parameter;
        }
        return null;
    }

    public List getParameters() {
        if (this.parameters == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.parameters.values());
        return list;
    }

    public List getParameters(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (List)parameter;
        }
        if (parameter instanceof Parameter) {
            Vector<Object> paramList = new Vector<Object>();
            paramList.add(parameter);
            this.parameters.put(name, paramList);
            return paramList;
        }
        return null;
    }

    public String getStringParameter(String name) {
        Parameter parameter = this.getParameter(name);
        return parameter != null ? parameter.value : null;
    }

    public String getStringParameter(String name, String defaultVal) {
        Parameter parameter = this.getParameter(name);
        return parameter != null ? parameter.value : defaultVal;
    }

    public boolean getBoolParameter(String name, boolean defaultVal) {
        if (this.parameters == null) {
            return defaultVal;
        }
        String paramVal = this.getStringParameter(name);
        if (paramVal == null) {
            return defaultVal;
        }
        if ((paramVal = paramVal.trim()).equals("true")) {
            return true;
        }
        if (paramVal.equals("false")) {
            return false;
        }
        return defaultVal;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public boolean isXmlDef() {
        return this.isXmlDef;
    }

    public String toString() {
        return "Target Profile: [" + Arrays.asList(this.profileTargetingExpressionStrings) + "], Selector: [" + this.selector + "], Selector Namespace URI: [" + this.namespaceURI + "], Resource: [" + this.resource + "], Num Params: [" + this.getParameterCount() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        String paramBasedData = this.getStringParameter(PARAM_RESDATA);
        if (paramBasedData != null) {
            return paramBasedData.getBytes();
        }
        if (this.resource != null) {
            InputStream resStream = null;
            try {
                resStream = uriResourceLocator.getResource(this.resource);
            }
            catch (Exception e) {
                return this.getInlineResourceBytes();
            }
            try {
                byte[] resourceBytes = null;
                if (resStream == null) {
                    throw new IOException("Resource [" + this.resource + "] not found.");
                }
                try {
                    resourceBytes = StreamUtils.readStream((InputStream)resStream);
                }
                finally {
                    resStream.close();
                }
                return resourceBytes;
            }
            catch (IOException e) {
                return this.getInlineResourceBytes();
            }
        }
        return null;
    }

    private byte[] getInlineResourceBytes() {
        try {
            return this.resource.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            return this.resource.getBytes();
        }
    }

    public Class toJavaResource() {
        if (this.resource == null) {
            return null;
        }
        String className = ClasspathUtils.toClassName(this.resource);
        try {
            return ClassUtil.forName((String)className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            if (this.resource.equals(className)) {
                logger.debug((Object)("Resource path [" + this.resource + "] looks as though it may be a Java resource reference.  If so, this class is not available on the classpath."));
            }
            return null;
        }
    }

    public boolean isJavaResource() {
        return this.toJavaResource() != null;
    }

    public boolean isJavaContentDeliveryUnit() {
        Class runtimeClass = this.toJavaResource();
        return runtimeClass != null && ContentDeliveryUnit.class.isAssignableFrom(runtimeClass);
    }

    public boolean isTargetedAtElementNamespace(Element element) {
        return this.namespaceURI == null || this.namespaceURI.equals(element.getNamespaceURI());
    }

    public boolean isSelectorContextual() {
        return this.contextualSelector.length > 1;
    }

    public boolean isTargetedAtElementContext(Element element) {
        Node currentNode = element;
        for (int i = this.contextualSelector.length - 1; i >= 0; --i) {
            if (currentNode == null || currentNode.getNodeType() != 1) {
                return false;
            }
            Element currentElement = currentNode;
            String elementName = DomUtils.getName(currentElement);
            if (!this.contextualSelector[i].equals("*") && !this.contextualSelector[i].equalsIgnoreCase(elementName)) {
                return false;
            }
            if (i <= 0) continue;
            currentNode = currentNode.getParentNode();
        }
        return true;
    }

    public boolean isTargetedAtElement(Element element) {
        if (!this.isTargetedAtElementNamespace(element)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + DomUtils.getXPath(element) + "].  Element not in namespace [" + this.getSelectorNamespaceURI() + "]."));
            }
            return false;
        }
        if (this.isSelectorContextual() && !this.isTargetedAtElementContext(element)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + DomUtils.getXPath(element) + "].  Element not in namespace [" + this.getSelectorNamespaceURI() + "]."));
            }
            return false;
        }
        return true;
    }
}

