/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.standalone.StandaloneApplicationContext;
import org.milyn.container.standalone.StandaloneExecutionContext;
import org.milyn.delivery.dom.SmooksDOMFilter;
import org.milyn.net.URIUtil;
import org.milyn.profile.UnknownProfileMemberException;
import org.milyn.resource.URIResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Smooks {
    private static Log logger = LogFactory.getLog(Smooks.class);
    private StandaloneApplicationContext context = new StandaloneApplicationContext();
    private boolean initialised = false;

    public Smooks() {
    }

    public Smooks(String resourceURI) throws IOException, SAXException {
        this();
        this.addConfigurations(resourceURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurations(String resourceURI) throws IOException, SAXException {
        AssertArgument.isNotNullAndNotEmpty((String)resourceURI, (String)"resourceURI");
        URIResourceLocator resourceLocator = new URIResourceLocator();
        InputStream resourceConfigStream = resourceLocator.getResource(resourceURI);
        try {
            URI resourceURIObj = new URI(resourceURI);
            this.addConfigurations(URIUtil.getParent((URI)resourceURIObj).toString(), resourceConfigStream);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Failed to load Smooks resource configuration '" + resourceURI + "'."), (Throwable)e);
        }
        finally {
            resourceConfigStream.close();
        }
    }

    public void addConfigurations(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty((String)baseURI, (String)"baseURI");
        AssertArgument.isNotNull((Object)resourceConfigStream, (String)"resourceConfigStream");
        try {
            this.context.getStore().registerResources(baseURI, resourceConfigStream);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to read resource configuration. Invalid 'baseURI'.");
        }
    }

    public StandaloneExecutionContext createExecutionContext() {
        return new StandaloneExecutionContext(StandaloneApplicationContext.OPEN_PROFILE_NAME, new LinkedHashMap(), this.context);
    }

    public StandaloneExecutionContext createExecutionContext(String targetProfile) throws UnknownProfileMemberException {
        return new StandaloneExecutionContext(targetProfile, new LinkedHashMap(), this.context);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filter(Source source, Result result, StandaloneExecutionContext executionContext) throws SmooksException {
        block33: {
            Node resultNode;
            AssertArgument.isNotNull((Object)source, (String)"source");
            AssertArgument.isNotNull((Object)result, (String)"result");
            AssertArgument.isNotNull((Object)executionContext, (String)"executionContext");
            if (!(source instanceof StreamSource) && !(source instanceof DOMSource)) {
                throw new IllegalArgumentException(source.getClass().getName() + " Source types not yet supported.");
            }
            if (!(result instanceof StreamResult) && !(result instanceof DOMResult)) {
                throw new IllegalArgumentException(result.getClass().getName() + " Result types not yet supported.");
            }
            SmooksDOMFilter smooks = new SmooksDOMFilter(executionContext);
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                if (streamSource.getInputStream() != null) {
                    resultNode = smooks.filter(new InputStreamReader(streamSource.getInputStream(), executionContext.getContentEncoding()));
                } else {
                    if (streamSource.getReader() == null) throw new SmooksException("Invalid " + StreamSource.class.getName() + ".  No InputStream or Reader instance.");
                    resultNode = smooks.filter(streamSource.getReader());
                }
            } else {
                Node node = ((DOMSource)source).getNode();
                if (!(node instanceof Document)) {
                    throw new IllegalArgumentException("DOMSource Source types must contain a Document node.");
                }
                resultNode = smooks.filter((Document)node);
            }
            if (result instanceof StreamResult) {
                Writer writer;
                StreamResult streamResult = (StreamResult)result;
                if (streamResult.getOutputStream() != null) {
                    writer = new OutputStreamWriter(streamResult.getOutputStream(), executionContext.getContentEncoding());
                } else {
                    if (streamResult.getWriter() == null) throw new SmooksException("Invalid " + StreamResult.class.getName() + ".  No OutputStream or Writer instance.");
                    writer = streamResult.getWriter();
                }
                try {
                    smooks.serialize(resultNode, writer);
                }
                catch (IOException e) {
                    logger.error((Object)"Error writing result to output stream.", (Throwable)e);
                }
                break block33;
            }
            ((DOMResult)result).setNode(resultNode);
        }
        Object var10_10 = null;
        if (source instanceof StreamSource) {
            try {
                StreamSource streamSource = (StreamSource)source;
                if (streamSource.getInputStream() != null) {
                    streamSource.getInputStream().close();
                } else if (streamSource.getReader() != null) {
                    streamSource.getReader().close();
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close input stream/reader.", (Throwable)e);
            }
        }
        if (!(result instanceof StreamResult)) return;
        StreamResult streamResult = (StreamResult)result;
        try {
            if (streamResult.getOutputStream() != null) {
                streamResult.getOutputStream().close();
                return;
            }
            if (streamResult.getWriter() == null) return;
            streamResult.getWriter().close();
            return;
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to close output stream/writer.", (Throwable)e);
        }
        return;
        {
            catch (UnsupportedEncodingException e) {
                throw new Error("Unexpected exception.  Encoding has already been validated as being unsupported.", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (source instanceof StreamSource) {
                try {
                    StreamSource streamSource = (StreamSource)source;
                    if (streamSource.getInputStream() != null) {
                        streamSource.getInputStream().close();
                    } else if (streamSource.getReader() != null) {
                        streamSource.getReader().close();
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Failed to close input stream/reader.", (Throwable)e);
                }
            }
            if (!(result instanceof StreamResult)) throw throwable;
            streamResult = (StreamResult)result;
            try {
                if (streamResult.getOutputStream() != null) {
                    streamResult.getOutputStream().close();
                    throw throwable;
                } else {
                    if (streamResult.getWriter() == null) throw throwable;
                    streamResult.getWriter().close();
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close output stream/writer.", (Throwable)e);
            }
            throw throwable;
        }
    }

    public StandaloneApplicationContext getApplicationContext() {
        return this.context;
    }
}

