/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.uddi.AccessPoint;
import org.apache.ws.scout.uddi.Address;
import org.apache.ws.scout.uddi.AddressLine;
import org.apache.ws.scout.uddi.BindingTemplate;
import org.apache.ws.scout.uddi.BindingTemplates;
import org.apache.ws.scout.uddi.BusinessEntity;
import org.apache.ws.scout.uddi.BusinessService;
import org.apache.ws.scout.uddi.BusinessServices;
import org.apache.ws.scout.uddi.CategoryBag;
import org.apache.ws.scout.uddi.Contact;
import org.apache.ws.scout.uddi.Contacts;
import org.apache.ws.scout.uddi.Description;
import org.apache.ws.scout.uddi.DiscoveryURL;
import org.apache.ws.scout.uddi.DiscoveryURLs;
import org.apache.ws.scout.uddi.Email;
import org.apache.ws.scout.uddi.HostingRedirector;
import org.apache.ws.scout.uddi.IdentifierBag;
import org.apache.ws.scout.uddi.KeyedReference;
import org.apache.ws.scout.uddi.Name;
import org.apache.ws.scout.uddi.Phone;
import org.apache.ws.scout.uddi.PublisherAssertion;
import org.apache.ws.scout.uddi.TModel;
import org.apache.ws.scout.uddi.TModelInstanceDetails;
import org.apache.ws.scout.uddi.TModelInstanceInfo;
import org.apache.ws.scout.uddi.URLType;
import org.apache.xmlbeans.XmlObject;

public class ScoutJaxrUddiHelper {
    private static Log log = LogFactory.getLog(ScoutJaxrUddiHelper.class);

    public static Address getAddress(PostalAddress post) throws JAXRException {
        Address address = Address.Factory.newInstance();
        AddressLine[] addarr = new AddressLine[6];
        String stnum = post.getStreetNumber();
        String st = post.getStreet();
        String city = post.getCity();
        String country = post.getCountry();
        String code = post.getPostalCode();
        String state = post.getStateOrProvince();
        AddressLine stnumAL = AddressLine.Factory.newInstance();
        stnumAL.setKeyName("STREET_NUMBER");
        if (stnum != null) {
            stnumAL.setKeyValue(stnum);
        }
        AddressLine stAL = AddressLine.Factory.newInstance();
        stAL.setKeyName("STREET");
        if (st != null) {
            stAL.setKeyValue(st);
        }
        AddressLine cityAL = AddressLine.Factory.newInstance();
        cityAL.setKeyName("CITY");
        if (city != null) {
            cityAL.setKeyValue(city);
        }
        AddressLine countryAL = AddressLine.Factory.newInstance();
        countryAL.setKeyName("COUNTRY");
        if (country != null) {
            countryAL.setKeyValue(country);
        }
        AddressLine codeAL = AddressLine.Factory.newInstance();
        codeAL.setKeyName("POSTALCODE");
        if (code != null) {
            codeAL.setKeyValue(code);
        }
        AddressLine stateAL = AddressLine.Factory.newInstance();
        stateAL.setKeyName("STATE");
        if (state != null) {
            stateAL.setKeyValue(state);
        }
        addarr[0] = stnumAL;
        addarr[1] = stAL;
        addarr[2] = cityAL;
        addarr[3] = countryAL;
        addarr[4] = codeAL;
        addarr[5] = stateAL;
        address.setAddressLineArray(addarr);
        return address;
    }

    public static BindingTemplate getBindingTemplateFromJAXRSB(ServiceBinding serve) throws JAXRException {
        BindingTemplate bt = BindingTemplate.Factory.newInstance();
        if (serve.getKey() != null && serve.getKey().getId() != null) {
            bt.setBindingKey(serve.getKey().getId());
        }
        try {
            InternationalString idesc;
            Service svc;
            ServiceBinding sb;
            String accessuri = serve.getAccessURI();
            if (accessuri != null) {
                AccessPoint ap = AccessPoint.Factory.newInstance();
                ap.setURLType(ScoutJaxrUddiHelper.getURLType(accessuri));
                ap.setStringValue(accessuri);
                bt.setAccessPoint(ap);
            }
            if ((sb = serve.getTargetBinding()) != null) {
                HostingRedirector red = HostingRedirector.Factory.newInstance();
                Key key = sb.getKey();
                if (key != null && key.getId() != null) {
                    red.setBindingKey(key.getId());
                }
                bt.setHostingRedirector(red);
            }
            if ((svc = serve.getService()) != null && svc.getKey() != null && svc.getKey().getId() != null) {
                bt.setServiceKey(svc.getKey().getId());
            }
            if ((idesc = serve.getDescription()) != null) {
                for (LocalizedString locName : idesc.getLocalizedStrings()) {
                    Description desc = bt.addNewDescription();
                    desc.setStringValue(locName.getValue());
                    desc.setLang(locName.getLocale().getLanguage());
                }
            }
            Collection slcol = serve.getSpecificationLinks();
            TModelInstanceDetails tid = TModelInstanceDetails.Factory.newInstance();
            if (slcol != null && slcol.isEmpty()) {
                for (SpecificationLink slink : slcol) {
                    TModelInstanceInfo emptyTInfo = tid.addNewTModelInstanceInfo();
                    if (slink.getSpecificationObject().getKey() == null || slink.getSpecificationObject().getKey().getId() == null) continue;
                    emptyTInfo.setTModelKey(slink.getSpecificationObject().getKey().getId());
                }
                bt.setTModelInstanceDetails(tid);
            }
            log.debug((Object)("BindingTemplate=" + bt.toString()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bt;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociation(Association assc) throws JAXRException {
        PublisherAssertion pa = PublisherAssertion.Factory.newInstance();
        try {
            if (assc.getSourceObject().getKey() != null && assc.getSourceObject().getKey().getId() != null) {
                pa.setFromKey(assc.getSourceObject().getKey().getId());
            }
            if (assc.getTargetObject().getKey() != null && assc.getTargetObject().getKey().getId() != null) {
                pa.setToKey(assc.getTargetObject().getKey().getId());
            }
            Concept c = assc.getAssociationType();
            String v = c.getValue();
            KeyedReference kr = KeyedReference.Factory.newInstance();
            Key key = c.getKey();
            if (key == null) {
                key = c.getClassificationScheme().getKey();
            }
            if (key == null || key.getId() == null) {
                kr.setTModelKey("");
            } else {
                kr.setTModelKey(key.getId());
            }
            kr.setKeyName("Concept");
            if (v != null) {
                kr.setKeyValue(v);
            }
            pa.setKeyedReference(kr);
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociationKey(String key) throws JAXRException {
        PublisherAssertion pa = PublisherAssertion.Factory.newInstance();
        try {
            StringTokenizer token = new StringTokenizer(key, ":");
            if (token.hasMoreTokens()) {
                pa.setFromKey(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                pa.setToKey(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                KeyedReference kr = KeyedReference.Factory.newInstance();
                String str = ScoutJaxrUddiHelper.getToken(token.nextToken());
                if ("UUID".equals(str)) {
                    str = str + ":" + ScoutJaxrUddiHelper.getToken(token.nextToken());
                }
                kr.setTModelKey(str);
                kr.setKeyName(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                kr.setKeyValue(ScoutJaxrUddiHelper.getToken(token.nextToken()));
                pa.setKeyedReference(kr);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static BusinessService getBusinessServiceFromJAXRService(Service serve) throws JAXRException {
        BusinessService bs = BusinessService.Factory.newInstance();
        try {
            Organization o;
            InternationalString iname = serve.getName();
            for (LocalizedString locName : iname.getLocalizedStrings()) {
                Name name = bs.addNewName();
                name.setStringValue(locName.getValue());
                name.setLang(locName.getLocale().getLanguage());
            }
            InternationalString idesc = serve.getDescription();
            if (idesc != null) {
                for (LocalizedString locName : idesc.getLocalizedStrings()) {
                    Description desc = bs.addNewDescription();
                    desc.setStringValue(locName.getValue());
                    desc.setLang(locName.getLocale().getLanguage());
                }
            }
            if ((o = serve.getProvidingOrganization()) != null) {
                Key k = o.getKey();
                if (k != null && k.getId() != null) {
                    bs.setBusinessKey(k.getId());
                }
            } else {
                throw new JAXRException("Service has no associated organization");
            }
            if (serve.getKey() != null && serve.getKey().getId() != null) {
                bs.setServiceKey(serve.getKey().getId());
            }
            bs.setCategoryBag(ScoutJaxrUddiHelper.getCategoryBagFromClassifications(serve.getClassifications()));
            BindingTemplates bt = ScoutJaxrUddiHelper.getBindingTemplates(serve.getServiceBindings());
            if (bt != null) {
                bs.setBindingTemplates(bt);
            }
            log.debug((Object)("BusinessService=" + bs.toString()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bs;
    }

    public static TModel getTModelFromJAXRClassificationScheme(ClassificationScheme scheme) throws JAXRException {
        TModel tm = TModel.Factory.newInstance();
        try {
            Slot s;
            Key k = scheme.getKey();
            if (k != null && k.getId() != null) {
                tm.setTModelKey(k.getId());
            }
            if ((s = scheme.getSlot("authorizedName")) != null && s.getName() != null) {
                tm.setAuthorizedName(s.getName());
            }
            if ((s = scheme.getSlot("operator")) != null && s.getName() != null) {
                tm.setOperator(s.getName());
            }
            InternationalString iname = scheme.getName();
            for (LocalizedString locName : iname.getLocalizedStrings()) {
                Name name = tm.addNewName();
                name.setStringValue(locName.getValue());
                name.setLang(locName.getLocale().getLanguage());
            }
            InternationalString idesc = scheme.getDescription();
            if (idesc != null) {
                for (LocalizedString locName : idesc.getLocalizedStrings()) {
                    Description desc = tm.addNewDescription();
                    desc.setStringValue(locName.getValue());
                    desc.setLang(locName.getLocale().getLanguage());
                }
            }
            tm.setIdentifierBag(ScoutJaxrUddiHelper.getIdentifierBagFromExternalIdentifiers(scheme.getExternalIdentifiers()));
            tm.setCategoryBag(ScoutJaxrUddiHelper.getCategoryBagFromClassifications(scheme.getClassifications()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    public static TModel getTModelFromJAXRConcept(Concept scheme) throws JAXRException {
        TModel tm = TModel.Factory.newInstance();
        if (scheme == null) {
            return null;
        }
        try {
            Slot sl2;
            Slot sl1;
            Key key = scheme.getKey();
            if (key != null && key.getId() != null) {
                tm.setTModelKey(key.getId());
            }
            if ((sl1 = scheme.getSlot("authorizedName")) != null && sl1.getName() != null) {
                tm.setAuthorizedName(sl1.getName());
            }
            if ((sl2 = scheme.getSlot("operator")) != null && sl2.getName() != null) {
                tm.setOperator(sl2.getName());
            }
            InternationalString iname = scheme.getName();
            for (LocalizedString locName : iname.getLocalizedStrings()) {
                Name name = tm.addNewName();
                name.setStringValue(locName.getValue());
                name.setLang(locName.getLocale().getLanguage());
            }
            InternationalString idesc = scheme.getDescription();
            if (idesc != null) {
                for (LocalizedString locName : idesc.getLocalizedStrings()) {
                    Description desc = tm.addNewDescription();
                    desc.setStringValue(locName.getValue());
                    desc.setLang(locName.getLocale().getLanguage());
                }
            }
            tm.setIdentifierBag(ScoutJaxrUddiHelper.getIdentifierBagFromExternalIdentifiers(scheme.getExternalIdentifiers()));
            tm.setCategoryBag(ScoutJaxrUddiHelper.getCategoryBagFromClassifications(scheme.getClassifications()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    public static BusinessEntity getBusinessEntityFromJAXROrg(Organization org) throws JAXRException {
        BusinessEntity biz = BusinessEntity.Factory.newInstance();
        BusinessServices bss = BusinessServices.Factory.newInstance();
        BusinessService[] barr = new BusinessService[]{};
        try {
            InternationalString idesc;
            InternationalString iname;
            Key key = org.getKey();
            if (key != null && key.getId() != null) {
                biz.setBusinessKey(key.getId());
            }
            if ((iname = org.getName()) != null) {
                for (LocalizedString locName : iname.getLocalizedStrings()) {
                    Name name = biz.addNewName();
                    name.setStringValue(locName.getValue());
                    name.setLang(locName.getLocale().getLanguage());
                }
            }
            if ((idesc = org.getDescription()) != null) {
                for (LocalizedString locName : idesc.getLocalizedStrings()) {
                    Description desc = biz.addNewDescription();
                    desc.setStringValue(locName.getValue());
                    desc.setLang(locName.getLocale().getLanguage());
                }
            }
            if (org.getPrimaryContact() != null && org.getPrimaryContact().getPersonName() != null && org.getPrimaryContact().getPersonName().getFullName() != null) {
                biz.setAuthorizedName(org.getPrimaryContact().getPersonName().getFullName());
            }
            Collection s = org.getServices();
            log.debug((Object)("?Org has services=" + s.isEmpty()));
            barr = new BusinessService[s.size()];
            Iterator iter = s.iterator();
            int barrPos = 0;
            while (iter.hasNext()) {
                BusinessService bs;
                barr[barrPos] = bs = ScoutJaxrUddiHelper.getBusinessServiceFromJAXRService((Service)iter.next());
                ++barrPos;
            }
            Contacts cts = Contacts.Factory.newInstance();
            Contact[] carr = new Contact[]{};
            User primaryContact = org.getPrimaryContact();
            Collection users = org.getUsers();
            int carrSize = 0;
            if (primaryContact != null) {
                ++carrSize;
            }
            for (User u : users) {
                if (u == primaryContact) continue;
                ++carrSize;
            }
            carr = new Contact[carrSize];
            log.debug((Object)("?Org has users=" + users.isEmpty()));
            if (primaryContact != null) {
                Contact ct;
                carr[0] = ct = ScoutJaxrUddiHelper.getContactFromJAXRUser(primaryContact);
            }
            Iterator it = users.iterator();
            int carrPos = 1;
            while (it.hasNext()) {
                Contact ct;
                User u = (User)it.next();
                if (u == primaryContact) continue;
                carr[carrPos] = ct = ScoutJaxrUddiHelper.getContactFromJAXRUser(u);
                ++carrPos;
            }
            bss.setBusinessServiceArray(barr);
            cts.setContactArray(carr);
            biz.setContacts(cts);
            biz.setBusinessServices(bss);
            Iterator exiter = org.getExternalLinks().iterator();
            DiscoveryURLs emptyDUs = null;
            boolean first = true;
            while (exiter.hasNext()) {
                ExternalLink link = (ExternalLink)exiter.next();
                if (first) {
                    emptyDUs = biz.addNewDiscoveryURLs();
                    first = false;
                }
                DiscoveryURL emptyDU = emptyDUs.addNewDiscoveryURL();
                emptyDU.setUseType("businessEntityExt");
                if (link.getExternalURI() == null) continue;
                emptyDU.setStringValue(link.getExternalURI());
            }
            biz.setIdentifierBag(ScoutJaxrUddiHelper.getIdentifierBagFromExternalIdentifiers(org.getExternalIdentifiers()));
            biz.setCategoryBag(ScoutJaxrUddiHelper.getCategoryBagFromClassifications(org.getClassifications()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return biz;
    }

    public static Contact getContactFromJAXRUser(User user) throws JAXRException {
        Contact ct = Contact.Factory.newInstance();
        if (user == null) {
            return ct;
        }
        Address[] addarr = new Address[]{};
        Phone[] phonearr = new Phone[]{};
        Email[] emailarr = new Email[]{};
        try {
            if (user.getPersonName() != null && user.getPersonName().getFullName() != null) {
                ct.setPersonName(user.getPersonName().getFullName());
            }
            if (user.getType() != null) {
                ct.setUseType(user.getType());
            }
            Collection postc = user.getPostalAddresses();
            addarr = new Address[postc.size()];
            Iterator iterator = postc.iterator();
            int addarrPos = 0;
            while (iterator.hasNext()) {
                PostalAddress post = (PostalAddress)iterator.next();
                addarr[addarrPos] = ScoutJaxrUddiHelper.getAddress(post);
                ++addarrPos;
            }
            Collection ph = user.getTelephoneNumbers(null);
            phonearr = new Phone[ph.size()];
            Iterator it = ph.iterator();
            int phonearrPos = 0;
            while (it.hasNext()) {
                TelephoneNumber t = (TelephoneNumber)it.next();
                Phone phone = Phone.Factory.newInstance();
                String str = t.getNumber();
                log.debug((Object)("Telephone=" + str));
                if (str != null) {
                    phone.setStringValue(str);
                } else {
                    phone.setStringValue("");
                }
                phonearr[phonearrPos] = phone;
                ++phonearrPos;
            }
            Collection ec = user.getEmailAddresses();
            emailarr = new Email[ec.size()];
            Iterator iter = ec.iterator();
            int emailarrPos = 0;
            while (iter.hasNext()) {
                EmailAddress ea = (EmailAddress)iter.next();
                Email email = Email.Factory.newInstance();
                if (ea.getAddress() != null) {
                    email.setStringValue(ea.getAddress());
                }
                if (ea.getType() != null) {
                    email.setUseType(ea.getType());
                }
                emailarr[emailarrPos] = email;
                ++emailarrPos;
            }
            ct.setAddressArray(addarr);
            ct.setPhoneArray(phonearr);
            ct.setEmailArray(emailarr);
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return ct;
    }

    private static String getToken(String tokenstr) {
        if (tokenstr.equals("NULL")) {
            tokenstr = "";
        }
        return tokenstr;
    }

    private static URLType.Enum getURLType(String accessuri) {
        String acc = accessuri.toLowerCase();
        URLType.Enum uri = URLType.OTHER;
        if (acc.startsWith("http:")) {
            uri = URLType.HTTP;
        } else if (acc.startsWith("https:")) {
            uri = URLType.HTTPS;
        } else if (acc.startsWith("ftp:")) {
            uri = URLType.FTP;
        } else if (acc.startsWith("phone:")) {
            uri = URLType.PHONE;
        }
        return uri;
    }

    public static CategoryBag getCategoryBagFromClassifications(Collection classifications) throws JAXRException {
        try {
            if (classifications == null) {
                return null;
            }
            CategoryBag cbag = (CategoryBag)XmlObject.Factory.newInstance().changeType(CategoryBag.type);
            for (Classification classification : classifications) {
                Key key;
                if (classification == null) continue;
                KeyedReference keyr = cbag.addNewKeyedReference();
                InternationalStringImpl iname = null;
                String value = null;
                ClassificationScheme scheme = classification.getClassificationScheme();
                if (classification.isExternal()) {
                    iname = (InternationalStringImpl)classification.getName();
                    value = classification.getValue();
                    scheme = classification.getClassificationScheme();
                } else {
                    Concept concept = classification.getConcept();
                    if (concept != null) {
                        iname = (InternationalStringImpl)concept.getName();
                        value = concept.getValue();
                        scheme = concept.getClassificationScheme();
                    }
                }
                String name = iname.getValue();
                if (name != null) {
                    keyr.setKeyName(name);
                }
                if (value != null) {
                    keyr.setKeyValue(value);
                }
                if (scheme == null || (key = scheme.getKey()) == null || key.getId() == null) continue;
                keyr.setTModelKey(key.getId());
            }
            return cbag;
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
    }

    public static IdentifierBag getIdentifierBagFromExternalIdentifiers(Collection identifiers) throws JAXRException {
        try {
            if (identifiers == null) {
                return null;
            }
            IdentifierBag ibag = (IdentifierBag)XmlObject.Factory.newInstance().changeType(IdentifierBag.type);
            for (ExternalIdentifier extid : identifiers) {
                Key key;
                if (extid == null) continue;
                KeyedReference keyr = ibag.addNewKeyedReference();
                InternationalStringImpl iname = (InternationalStringImpl)extid.getName();
                String value = extid.getValue();
                ClassificationScheme scheme = extid.getIdentificationScheme();
                String name = iname.getValue();
                if (name != null) {
                    keyr.setKeyName(name);
                }
                if (value != null) {
                    keyr.setKeyValue(value);
                }
                if (scheme == null || (key = scheme.getKey()) == null || key.getId() == null) continue;
                keyr.setTModelKey(key.getId());
            }
            return ibag;
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
    }

    private static BindingTemplates getBindingTemplates(Collection serviceBindings) throws JAXRException {
        BindingTemplates bt = BindingTemplates.Factory.newInstance();
        if (serviceBindings != null) {
            Iterator iter = serviceBindings.iterator();
            int currLoc = 0;
            BindingTemplate[] bindingTemplateArray = new BindingTemplate[serviceBindings.size()];
            while (iter.hasNext()) {
                ServiceBinding sb = (ServiceBinding)iter.next();
                bindingTemplateArray[currLoc] = ScoutJaxrUddiHelper.getBindingTemplateFromJAXRSB(sb);
                ++currLoc;
            }
            if (bindingTemplateArray != null) {
                bt.setBindingTemplateArray(bindingTemplateArray);
            }
        }
        return bt;
    }
}

