/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFStream;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDFMetadata
extends PDFStream {
    private static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    private static DateFormat pseudoISO8601DateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
    private Document xmpMetadata;
    private boolean readOnly = true;

    public PDFMetadata(Document xmp, boolean readOnly) {
        if (xmp == null) {
            throw new NullPointerException("DOM Document representing the metadata must no be null");
        }
        this.xmpMetadata = xmp;
        this.readOnly = readOnly;
    }

    protected void setupFilterList() {
        if (!this.getFilterList().isInitialized()) {
            this.getFilterList().addDefaultFilters(this.getDocumentSafely().getFilterMap(), "metadata");
        }
        super.setupFilterList();
    }

    protected boolean allowEncryption() {
        return false;
    }

    protected int output(OutputStream stream) throws IOException {
        int length = super.output(stream);
        this.xmpMetadata = null;
        return length;
    }

    protected void outputRawStreamData(OutputStream out) throws IOException {
        String encoding = "UTF-8";
        out.write("<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n".getBytes("UTF-8"));
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            DOMSource src = new DOMSource(this.xmpMetadata);
            StreamResult res = new StreamResult(out);
            transformer.transform(src, res);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Error setting up Transformer for XMP stream serialization: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException("Error while serializing XMP stream: " + e.getMessage());
        }
        if (this.readOnly) {
            out.write("\n<?xpacket end=\"r\"?>".getBytes("UTF-8"));
        } else {
            StringBuffer sb = new StringBuffer(101);
            sb.append('\n');
            for (int i = 0; i < 100; ++i) {
                sb.append(" ");
            }
            byte[] padding = sb.toString().getBytes("UTF-8");
            for (int i = 0; i < 40; ++i) {
                out.write(padding);
            }
            out.write("\n<?xpacket end=\"w\"?>".getBytes("UTF-8"));
        }
    }

    protected String buildStreamDict(String lengthEntry) {
        String filterEntry = this.getFilterList().buildFilterDictEntries();
        if (this.getDocumentSafely().getPDFAMode().isPDFA1LevelB() && filterEntry != null && filterEntry.length() > 0) {
            throw new PDFConformanceException("The Filter key is prohibited when PDF/A-1 is active");
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getObjectID());
        sb.append("<< ");
        sb.append("/Type /Metadata");
        sb.append("\n/Subtype /XML");
        sb.append("\n/Length " + lengthEntry);
        sb.append("\n" + filterEntry);
        sb.append("\n>>\n");
        return sb.toString();
    }

    public static String formatISO8601Date(Date dt) {
        StringBuffer sb = new StringBuffer(pseudoISO8601DateFormat.format(dt));
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int offset = cal.get(15);
        offset += cal.get(16);
        if ((offset /= 60000) == 0) {
            sb.append('Z');
        } else {
            int zoh = offset / 60;
            int zom = Math.abs(offset % 60);
            if (zoh > 0) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (zoh < 10) {
                sb.append('0');
            }
            sb.append(zoh);
            sb.append(':');
            if (zom < 10) {
                sb.append('0');
            }
            sb.append(zom);
        }
        return sb.toString();
    }

    public static Document createXMPFromUserAgent(PDFDocument pdfDoc) {
        Element el;
        DOMImplementation domImplementation = ElementMapping.getDefaultDOMImplementation();
        Document doc = domImplementation.createDocument("adobe:ns:meta/", "x:xmpmeta", null);
        Element rdf = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:RDF");
        doc.getDocumentElement().appendChild(rdf);
        PDFInfo info = pdfDoc.getInfo();
        if (info.getCreationDate() == null) {
            Date d = new Date();
            info.setCreationDate(d);
        }
        Element desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        desc.setAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:about", "");
        desc.setAttributeNS(XMLNS, "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        rdf.appendChild(desc);
        if (info.getAuthor() != null) {
            el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:creator");
            desc.appendChild(el);
            Element seq = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Seq");
            el.appendChild(seq);
            Element li = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:li");
            seq.appendChild(li);
            li.appendChild(doc.createTextNode(info.getAuthor()));
        }
        if (info.getTitle() != null) {
            el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:title");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getTitle()));
        }
        if (info.getSubject() != null) {
            el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:subject");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getSubject()));
        }
        el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:date");
        desc.appendChild(el);
        el.appendChild(doc.createTextNode(PDFMetadata.formatISO8601Date(info.getCreationDate())));
        desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        desc.setAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:about", "");
        desc.setAttributeNS(XMLNS, "xmlns:xmp", "http://ns.adobe.com/xap/1.0/");
        rdf.appendChild(desc);
        el = doc.createElementNS("http://ns.adobe.com/xap/1.0/", "xmp:CreateDate");
        desc.appendChild(el);
        el.appendChild(doc.createTextNode(PDFMetadata.formatISO8601Date(info.getCreationDate())));
        if (info.getCreator() != null) {
            el = doc.createElementNS("http://ns.adobe.com/xap/1.0/", "xmp:CreatorTool");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getCreator()));
        }
        desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        desc.setAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:about", "");
        desc.setAttributeNS(XMLNS, "xmlns:pdf", "http://ns.adobe.com/pdf/1.3/");
        rdf.appendChild(desc);
        if (info.getKeywords() != null) {
            el = doc.createElementNS("http://ns.adobe.com/pdf/1.3/", "pdf:Keywords");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getKeywords()));
        }
        if (info.getProducer() != null) {
            el = doc.createElementNS("http://ns.adobe.com/pdf/1.3/", "pdf:Producer");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getProducer()));
        }
        el = doc.createElementNS("http://ns.adobe.com/pdf/1.3/", "pdf:PDFVersion");
        desc.appendChild(el);
        el.appendChild(doc.createTextNode(pdfDoc.getPDFVersionString()));
        PDFAMode pdfaMode = pdfDoc.getPDFAMode();
        if (pdfaMode.isPDFA1LevelB()) {
            PDFMetadata.createPDFAIndentification(doc, rdf, "http://www.aiim.org/pdfa/ns/id", "pdfaid", pdfaMode);
            PDFMetadata.createPDFAIndentification(doc, rdf, "http://www.aiim.org/pdfa/ns/id.html", "pdfaid_1", pdfaMode);
        }
        return doc;
    }

    private static void createPDFAIndentification(Document doc, Element rdf, String pdfaNamespace, String prefix, PDFAMode pdfaMode) {
        Element desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        desc.setAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:about", "");
        desc.setAttributeNS(XMLNS, "xmlns:" + prefix, pdfaNamespace);
        rdf.appendChild(desc);
        Element el = doc.createElementNS(pdfaNamespace, prefix + ":part");
        desc.appendChild(el);
        el.appendChild(doc.createTextNode("1"));
        el = doc.createElementNS(pdfaNamespace, prefix + ":conformance");
        desc.appendChild(el);
        if (pdfaMode == PDFAMode.PDFA_1A) {
            el.appendChild(doc.createTextNode("A"));
        } else {
            el.appendChild(doc.createTextNode("B"));
        }
    }
}

