/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;

public class BitmapImage
implements PDFImage {
    private int height;
    private int width;
    private int bitsPerPixel;
    private PDFColorSpace colorSpace;
    private byte[] bitmaps;
    private String maskRef;
    private PDFColor transparent = null;
    private String key;
    private PDFDocument pdfDoc;

    public BitmapImage(String k, int width, int height, byte[] data, String mask) {
        this.key = k;
        this.height = height;
        this.width = width;
        this.bitsPerPixel = 8;
        this.colorSpace = new PDFColorSpace(2);
        this.bitmaps = data;
        this.maskRef = mask;
    }

    public void setup(PDFDocument doc) {
        this.pdfDoc = doc;
    }

    public String getKey() {
        return this.key;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setColorSpace(PDFColorSpace cs) {
        this.colorSpace = cs;
    }

    public PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public void setTransparent(PDFColor t) {
        this.transparent = t;
    }

    public boolean isTransparent() {
        return this.transparent != null;
    }

    public PDFColor getTransparentColor() {
        return this.transparent;
    }

    public String getMask() {
        return null;
    }

    public String getSoftMask() {
        return this.maskRef;
    }

    public boolean isInverted() {
        return false;
    }

    public void outputContents(OutputStream out) throws IOException {
        out.write(this.bitmaps);
    }

    public PDFICCStream getICCStream() {
        return null;
    }

    public boolean isPS() {
        return false;
    }

    public String getFilterHint() {
        return "image";
    }

    public PDFFilter getPDFFilter() {
        return null;
    }
}

