/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.MinOptMaxUtil;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.EmptyGridUnit;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableRowIterator;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.traits.MinOptMax;

public class TableContentLayoutManager
implements PercentBaseContext {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$table$TableContentLayoutManager == null ? (class$org$apache$fop$layoutmgr$table$TableContentLayoutManager = TableContentLayoutManager.class$("org.apache.fop.layoutmgr.table.TableContentLayoutManager")) : class$org$apache$fop$layoutmgr$table$TableContentLayoutManager));
    private TableLayoutManager tableLM;
    private TableRowIterator trIter;
    private TableRowIterator headerIter;
    private TableRowIterator footerIter;
    private LinkedList headerList;
    private LinkedList footerList;
    private int headerNetHeight = 0;
    private int footerNetHeight = 0;
    private boolean firstBreakBeforeServed = false;
    private int startXOffset;
    private int usedBPD;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableContentLayoutManager;

    public TableContentLayoutManager(TableLayoutManager parent) {
        this.tableLM = parent;
        Table table = this.getTableLM().getTable();
        this.trIter = new TableRowIterator(table, this.getTableLM().getColumns(), 0);
        if (table.getTableHeader() != null) {
            this.headerIter = new TableRowIterator(table, this.getTableLM().getColumns(), 1);
        }
        if (table.getTableFooter() != null) {
            this.footerIter = new TableRowIterator(table, this.getTableLM().getColumns(), 2);
        }
    }

    public TableLayoutManager getTableLM() {
        return this.tableLM;
    }

    private boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    public ColumnSetup getColumns() {
        return this.getTableLM().getColumns();
    }

    protected int getHeaderNetHeight() {
        return this.headerNetHeight;
    }

    protected int getFooterNetHeight() {
        return this.footerNetHeight;
    }

    protected LinkedList getHeaderElements() {
        return this.headerList;
    }

    protected LinkedList getFooterElements() {
        return this.footerList;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        KnuthBox box;
        TableHeaderFooterPosition pos;
        log.debug((Object)("==> Columns: " + this.getTableLM().getColumns()));
        KnuthBox headerAsFirst = null;
        KnuthBox headerAsSecondToLast = null;
        KnuthBox footerAsLast = null;
        if (this.headerIter != null && this.headerList == null) {
            this.headerList = this.getKnuthElementsForRowIterator(this.headerIter, context, alignment, 1);
            ElementListUtils.removeLegalBreaks(this.headerList);
            this.headerNetHeight = ElementListUtils.calcContentLength(this.headerList);
            if (log.isDebugEnabled()) {
                log.debug((Object)("==> Header: " + this.headerNetHeight + " - " + this.headerList));
            }
            pos = new TableHeaderFooterPosition(this.getTableLM(), true, this.headerList);
            box = new KnuthBox(this.headerNetHeight, pos, false);
            if (this.getTableLM().getTable().omitHeaderAtBreak()) {
                headerAsFirst = box;
            } else {
                headerAsSecondToLast = box;
            }
        }
        if (this.footerIter != null && this.footerList == null) {
            this.footerList = this.getKnuthElementsForRowIterator(this.footerIter, context, alignment, 2);
            ElementListUtils.removeLegalBreaks(this.footerList);
            this.footerNetHeight = ElementListUtils.calcContentLength(this.footerList);
            if (log.isDebugEnabled()) {
                log.debug((Object)("==> Footer: " + this.footerNetHeight + " - " + this.footerList));
            }
            pos = new TableHeaderFooterPosition(this.getTableLM(), false, this.footerList);
            footerAsLast = box = new KnuthBox(this.footerNetHeight, pos, false);
        }
        LinkedList returnList = this.getKnuthElementsForRowIterator(this.trIter, context, alignment, 0);
        if (headerAsFirst != null) {
            returnList.add(0, headerAsFirst);
        } else if (headerAsSecondToLast != null) {
            returnList.add(headerAsSecondToLast);
        }
        if (footerAsLast != null) {
            returnList.add(footerAsLast);
        }
        return returnList;
    }

    private LinkedList getKnuthElementsForRowIterator(TableRowIterator iter, LayoutContext context, int alignment, int bodyType) {
        ListElement last;
        LinkedList<BreakElement> returnList = new LinkedList<BreakElement>();
        EffRow[] rowGroup = null;
        while ((rowGroup = iter.getNextRowGroup()) != null) {
            BreakElement breakPoss;
            KnuthPenalty pen;
            ListElement last2;
            TableRow rowFO;
            block8: {
                block9: {
                    block10: {
                        rowFO = rowGroup[0].getTableRow();
                        if (rowFO == null || rowFO.getBreakBefore() == 9) break block8;
                        log.info((Object)"break-before found");
                        if (returnList.size() <= 0) break block9;
                        last2 = (ListElement)returnList.getLast();
                        if (!last2.isPenalty()) break block10;
                        pen = (KnuthPenalty)last2;
                        pen.setP(-1000);
                        pen.setBreakClass(rowFO.getBreakBefore());
                        break block8;
                    }
                    if (!(last2 instanceof BreakElement)) break block8;
                    breakPoss = (BreakElement)last2;
                    breakPoss.setPenaltyValue(-1000);
                    breakPoss.setBreakClass(rowFO.getBreakBefore());
                    break block8;
                }
                if (!this.firstBreakBeforeServed) {
                    returnList.add(new BreakElement(new Position(this.getTableLM()), 0, -1000, rowFO.getBreakBefore(), context));
                    iter.backToPreviousRow();
                    this.firstBreakBeforeServed = true;
                    break;
                }
            }
            this.firstBreakBeforeServed = true;
            if (!this.isSeparateBorderModel()) {
                this.resolveNormalBeforeAfterBordersForRowGroup(rowGroup, iter);
            }
            this.createElementsForRowGroup(context, alignment, bodyType, returnList, rowGroup);
            if (context.isKeepWithNextPending()) {
                log.debug((Object)"child LM (row group) signals pending keep-with-next");
            }
            if (context.isKeepWithPreviousPending()) {
                log.debug((Object)"child LM (row group) signals pending keep-with-previous");
                if (returnList.size() > 0 && (last2 = (ListElement)returnList.getLast()).isPenalty() && !(breakPoss = (BreakElement)last2).isForcedBreak()) {
                    breakPoss.setPenaltyValue(1000);
                }
            }
            if ((rowFO = rowGroup[rowGroup.length - 1].getTableRow()) == null || rowFO.getBreakAfter() == 9 || returnList.size() <= 0) continue;
            last2 = (ListElement)returnList.getLast();
            if (last2 instanceof KnuthPenalty) {
                pen = (KnuthPenalty)last2;
                pen.setP(-1000);
                pen.setBreakClass(rowFO.getBreakAfter());
                continue;
            }
            if (!(last2 instanceof BreakElement)) continue;
            breakPoss = (BreakElement)last2;
            breakPoss.setPenaltyValue(-1000);
            breakPoss.setBreakClass(rowFO.getBreakAfter());
        }
        if (returnList.size() > 0 && ((last = (ListElement)returnList.getLast()).isPenalty() || last instanceof BreakElement) && !last.isForcedBreak()) {
            returnList.removeLast();
        }
        return returnList;
    }

    private void resolveNormalBeforeAfterBordersForRowGroup(EffRow[] rowGroup, TableRowIterator iter) {
        for (int rgi = 0; rgi < rowGroup.length; ++rgi) {
            int i;
            EffRow row = rowGroup[rgi];
            EffRow prev = iter.getCachedRow(row.getIndex() - 1);
            EffRow next = iter.getCachedRow(row.getIndex() + 1);
            if (next == null) {
                next = iter.getNextRow();
                iter.backToPreviousRow();
            }
            if (prev == null && iter == this.trIter && this.headerIter != null) {
                prev = this.headerIter.getLastRow();
            }
            if (next == null && iter == this.headerIter) {
                next = this.trIter.getFirstRow();
            }
            if (next == null && iter == this.trIter && this.footerIter != null) {
                next = this.footerIter.getFirstRow();
            }
            if (prev == null && iter == this.footerIter) {
                prev = this.trIter.getLastRow();
            }
            log.debug((Object)(prev + " - " + row + " - " + next));
            int guCount = row.getGridUnits().size();
            if (prev != null) {
                guCount = Math.max(guCount, prev.getGridUnits().size());
            }
            if (next != null) {
                guCount = Math.max(guCount, next.getGridUnits().size());
            }
            GridUnit gu = row.getGridUnit(0);
            for (i = 0; i < guCount - row.getGridUnits().size(); ++i) {
                int pos = row.getGridUnits().size() + i;
                row.getGridUnits().add(new EmptyGridUnit(gu.getRow(), this.tableLM.getColumns().getColumn(pos + 1), gu.getBody(), pos));
            }
            if (this.getTableLM().getTable().isSeparateBorderModel()) continue;
            for (i = 0; i < row.getGridUnits().size(); ++i) {
                gu = row.getGridUnit(i);
                int flags = 0;
                GridUnit other = prev != null && i < prev.getGridUnits().size() ? prev.getGridUnit(i) : null;
                if (other == null || other.isEmpty() || gu.isEmpty() || gu.getPrimary() != other.getPrimary()) {
                    if (iter == this.trIter && gu.getFlag(2) && this.headerIter == null) {
                        flags |= 1;
                    }
                    if (iter == this.headerIter && gu.getFlag(2)) {
                        flags |= 1;
                    }
                    gu.resolveBorder(other, 0, flags);
                }
                flags = 0;
                other = next != null && i < next.getGridUnits().size() ? next.getGridUnit(i) : null;
                if (other != null && !other.isEmpty() && !gu.isEmpty() && gu.getPrimary() == other.getPrimary()) continue;
                if (iter == this.trIter && gu.getFlag(5) && this.footerIter == null) {
                    flags |= 1;
                }
                if (iter == this.footerIter && gu.getFlag(5)) {
                    flags |= 1;
                }
                gu.resolveBorder(other, 1, flags);
            }
        }
    }

    private void createElementsForRowGroup(LayoutContext context, int alignment, int bodyType, LinkedList returnList, EffRow[] rowGroup) {
        TableStepper stepper;
        LinkedList returnedList;
        log.debug((Object)("Handling row group with " + rowGroup.length + " rows..."));
        MinOptMax[] rowHeights = new MinOptMax[rowGroup.length];
        MinOptMax[] explicitRowHeights = new MinOptMax[rowGroup.length];
        int maxColumnCount = 0;
        ArrayList<PrimaryGridUnit> pgus = new ArrayList<PrimaryGridUnit>();
        for (int rgi = 0; rgi < rowGroup.length; ++rgi) {
            EffRow row = rowGroup[rgi];
            rowHeights[rgi] = new MinOptMax(0, 0, Integer.MAX_VALUE);
            explicitRowHeights[rgi] = new MinOptMax(0, 0, Integer.MAX_VALUE);
            pgus.clear();
            TableRow tableRow = null;
            int minContentHeight = 0;
            int maxCellHeight = 0;
            int effRowContentHeight = 0;
            for (int j = 0; j < row.getGridUnits().size(); ++j) {
                maxColumnCount = Math.max(maxColumnCount, row.getGridUnits().size());
                GridUnit gu = row.getGridUnit(j);
                if (!gu.isPrimary() && (gu.getColSpanIndex() != 0 || !gu.isLastGridUnitRowSpan()) || gu.isEmpty()) continue;
                PrimaryGridUnit primary = gu.getPrimary();
                if (gu.isPrimary()) {
                    primary.getCellLM().setParent(this.getTableLM());
                    if (tableRow == null && primary.getRow() != null) {
                        tableRow = primary.getRow();
                        LengthRangeProperty bpd = tableRow.getBlockProgressionDimension();
                        if (!bpd.getMinimum(this.getTableLM()).isAuto()) {
                            minContentHeight = Math.max(minContentHeight, bpd.getMinimum(this.getTableLM()).getLength().getValue(this.getTableLM()));
                        }
                        MinOptMaxUtil.restrict(explicitRowHeights[rgi], bpd, this.getTableLM());
                    }
                    int spanWidth = 0;
                    for (int i = primary.getStartCol(); i < primary.getStartCol() + primary.getCell().getNumberColumnsSpanned(); ++i) {
                        if (this.getTableLM().getColumns().getColumn(i + 1) == null) continue;
                        spanWidth += this.getTableLM().getColumns().getColumn(i + 1).getColumnWidth().getValue(this.getTableLM());
                    }
                    LayoutContext childLC = new LayoutContext(0);
                    childLC.setStackLimit(context.getStackLimit());
                    childLC.setRefIPD(spanWidth);
                    LinkedList elems = primary.getCellLM().getNextKnuthElements(childLC, alignment);
                    while (!primary.getCellLM().isFinished()) {
                        LinkedList additionalElems = primary.getCellLM().getNextKnuthElements(childLC, alignment);
                        elems.addAll(additionalElems);
                    }
                    ElementListObserver.observe(elems, "table-cell", primary.getCell().getId());
                    if (elems.size() > 0 && ((KnuthElement)elems.getLast()).isForcedBreak()) {
                        log.debug((Object)("Descendant of table-cell signals break: " + primary.getCellLM().isFinished()));
                    }
                    primary.setElements(elems);
                    if (childLC.isKeepWithNextPending()) {
                        log.debug((Object)"child LM signals pending keep-with-next");
                        primary.setFlag(6, true);
                    }
                    if (childLC.isKeepWithPreviousPending()) {
                        log.debug((Object)"child LM signals pending keep-with-previous");
                        primary.setFlag(7, true);
                    }
                }
                primary.setContentLength(ElementListUtils.calcContentLength(primary.getElements()));
                maxCellHeight = Math.max(maxCellHeight, primary.getContentLength());
                if (gu.isLastGridUnitRowSpan()) {
                    int effCellContentHeight = minContentHeight;
                    LengthRangeProperty bpd = primary.getCell().getBlockProgressionDimension();
                    if (!bpd.getMinimum(this.getTableLM()).isAuto()) {
                        effCellContentHeight = Math.max(effCellContentHeight, bpd.getMinimum(this.getTableLM()).getLength().getValue(this.getTableLM()));
                    }
                    if (!bpd.getOptimum(this.getTableLM()).isAuto()) {
                        effCellContentHeight = Math.max(effCellContentHeight, bpd.getOptimum(this.getTableLM()).getLength().getValue(this.getTableLM()));
                    }
                    if (gu.getRowSpanIndex() == 0) {
                        MinOptMaxUtil.restrict(explicitRowHeights[rgi], bpd, this.tableLM);
                    }
                    effCellContentHeight = Math.max(effCellContentHeight, primary.getContentLength());
                    int borderWidths = this.isSeparateBorderModel() ? primary.getBorders().getBorderBeforeWidth(false) + primary.getBorders().getBorderAfterWidth(false) : primary.getHalfMaxBorderWidth();
                    int padding = 0;
                    effRowContentHeight = Math.max(effRowContentHeight, effCellContentHeight);
                    CommonBorderPaddingBackground cbpb = primary.getCell().getCommonBorderPaddingBackground();
                    padding += cbpb.getPaddingBefore(false, primary.getCellLM());
                    int effRowHeight = effCellContentHeight + (padding += cbpb.getPaddingAfter(false, primary.getCellLM())) + borderWidths + 2 * this.getTableLM().getHalfBorderSeparationBPD();
                    for (int previous = 0; previous < gu.getRowSpanIndex(); ++previous) {
                        effRowHeight -= rowHeights[rgi - previous - 1].opt;
                    }
                    if (effRowHeight > rowHeights[rgi].min) {
                        MinOptMaxUtil.extendMinimum(rowHeights[rgi], effRowHeight, false);
                    }
                }
                if (!gu.isPrimary()) continue;
                pgus.add(primary);
            }
            row.setHeight(rowHeights[rgi]);
            row.setExplicitHeight(explicitRowHeights[rgi]);
            if (effRowContentHeight <= row.getExplicitHeight().max) continue;
            log.warn((Object)FONode.decorateWithContextInfo("The contents of row " + (row.getIndex() + 1) + " are taller than they should be (there is a" + " block-progression-dimension or height constraint on the indicated row)." + " Due to its contents the row grows" + " to " + effRowContentHeight + " millipoints, but the row shouldn't get" + " any taller than " + row.getExplicitHeight() + " millipoints.", row.getTableRow()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"rowGroup:");
            for (int i = 0; i < rowHeights.length; ++i) {
                log.debug((Object)("  height=" + rowHeights[i] + " explicit=" + explicitRowHeights[i]));
            }
        }
        if ((returnedList = (stepper = new TableStepper(this)).getCombinedKnuthElementsForRowGroup(context, rowGroup, maxColumnCount, bodyType)) != null) {
            returnList.addAll(returnedList);
        }
    }

    protected int getXOffsetOfGridUnit(GridUnit gu) {
        int col = gu.getStartCol();
        return this.startXOffset + this.getTableLM().getColumns().getXOffset(col + 1, this.getTableLM());
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        Map markers;
        this.usedBPD = 0;
        RowPainter painter = new RowPainter(layoutContext);
        ArrayList<Position> positions = new ArrayList<Position>();
        List headerElements = null;
        List footerElements = null;
        Position firstPos = null;
        Position lastPos = null;
        Position lastCheckPos = null;
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos instanceof SpaceResolver.SpaceHandlingBreakPosition) {
                pos = ((SpaceResolver.SpaceHandlingBreakPosition)pos).getOriginalBreakPosition();
            }
            if (pos == null) continue;
            if (firstPos == null) {
                firstPos = pos;
            }
            lastPos = pos;
            if (pos.getIndex() >= 0) {
                lastCheckPos = pos;
            }
            if (pos instanceof TableHeaderFooterPosition) {
                TableHeaderFooterPosition thfpos = (TableHeaderFooterPosition)pos;
                if (thfpos.header) {
                    headerElements = thfpos.nestedElements;
                    continue;
                }
                footerElements = thfpos.nestedElements;
                continue;
            }
            if (pos instanceof TableHFPenaltyPosition) continue;
            positions.add(pos);
        }
        if (lastPos instanceof TableHFPenaltyPosition) {
            TableHFPenaltyPosition penaltyPos = (TableHFPenaltyPosition)lastPos;
            log.debug((Object)"Break at penalty!");
            if (penaltyPos.headerElements != null) {
                headerElements = penaltyPos.headerElements;
            }
            if (penaltyPos.footerElements != null) {
                footerElements = penaltyPos.footerElements;
            }
        }
        if ((markers = this.getTableLM().getTable().getMarkers()) != null) {
            this.getTableLM().getCurrentPV().addMarkers(markers, true, this.getTableLM().isFirst(firstPos), this.getTableLM().isLast(lastCheckPos));
        }
        if (headerElements != null) {
            KnuthPossPosIter nestedIter = new KnuthPossPosIter(headerElements);
            this.iterateAndPaintPositions(nestedIter, painter);
            painter.addAreasAndFlushRow(true);
        }
        Iterator posIter = positions.iterator();
        this.iterateAndPaintPositions(posIter, painter);
        painter.addAreasAndFlushRow(true);
        if (footerElements != null) {
            KnuthPossPosIter nestedIter = new KnuthPossPosIter(footerElements);
            this.iterateAndPaintPositions(nestedIter, painter);
            painter.addAreasAndFlushRow(true);
        }
        painter.notifyEndOfSequence();
        this.usedBPD += painter.getAccumulatedBPD();
        if (markers != null) {
            this.getTableLM().getCurrentPV().addMarkers(markers, false, this.getTableLM().isFirst(firstPos), this.getTableLM().isLast(lastCheckPos));
        }
    }

    private void iterateAndPaintPositions(Iterator iterator, RowPainter painter) {
        ArrayList<TableContentPosition> lst = new ArrayList<TableContentPosition>();
        boolean firstPos = false;
        boolean lastPos = false;
        FObj body = null;
        while (iterator.hasNext()) {
            Position pos = (Position)iterator.next();
            if (pos instanceof TableContentPosition) {
                TableContentPosition tcpos = (TableContentPosition)pos;
                lst.add(tcpos);
                GridUnitPart part = (GridUnitPart)tcpos.gridUnitParts.get(0);
                if (body == null) {
                    body = part.pgu.getBody();
                }
                if (tcpos.getFlag(1) && tcpos.row.getFlag(3)) {
                    firstPos = true;
                }
                if (!tcpos.getFlag(2) || !tcpos.row.getFlag(4)) continue;
                lastPos = true;
                this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), true, firstPos, lastPos);
                int size = lst.size();
                for (int i = 0; i < size; ++i) {
                    painter.handleTableContentPosition((TableContentPosition)lst.get(i));
                }
                this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), false, firstPos, lastPos);
                firstPos = false;
                lastPos = false;
                body = null;
                lst.clear();
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignoring position: " + pos));
        }
        if (body != null) {
            this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), true, firstPos, lastPos);
            int size = lst.size();
            for (int i = 0; i < size; ++i) {
                painter.handleTableContentPosition((TableContentPosition)lst.get(i));
            }
            this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), false, firstPos, lastPos);
        }
    }

    public Block getRowArea(TableRow row) {
        if (row == null || !row.getCommonBorderPaddingBackground().hasBackground()) {
            return null;
        }
        Block block = new Block();
        block.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
        block.setPositioning(2);
        return block;
    }

    public void addRowBackgroundArea(TableRow row, int bpd, int ipd, int yoffset) {
        Block rowBackground = this.getRowArea(row);
        if (rowBackground != null) {
            rowBackground.setBPD(bpd);
            rowBackground.setIPD(ipd);
            rowBackground.setXOffset(this.startXOffset);
            rowBackground.setYOffset(yoffset);
            this.getTableLM().addChildArea(rowBackground);
            TraitSetter.addBackground(rowBackground, row.getCommonBorderPaddingBackground(), this.getTableLM());
        }
    }

    public void setStartXOffset(int startXOffset) {
        this.startXOffset = startXOffset;
    }

    public int getUsedBPD() {
        return this.usedBPD;
    }

    public int getBaseLength(int lengthBase, FObj fobj) {
        return this.tableLM.getBaseLength(lengthBase, fobj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TableHFPenaltyPosition
    extends Position {
        protected List headerElements;
        protected List footerElements;

        protected TableHFPenaltyPosition(LayoutManager lm) {
            super(lm);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("TableHFPenaltyPosition:");
            sb.append(this.getIndex()).append("(");
            sb.append("header:");
            sb.append(this.headerElements);
            sb.append(", footer:");
            sb.append(this.footerElements);
            sb.append(")");
            return sb.toString();
        }
    }

    public static class TableHeaderFooterPosition
    extends Position {
        protected boolean header;
        protected List nestedElements;

        protected TableHeaderFooterPosition(LayoutManager lm, boolean header, List nestedElements) {
            super(lm);
            this.header = header;
            this.nestedElements = nestedElements;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Table");
            sb.append(this.header ? "Header" : "Footer");
            sb.append("Position:");
            sb.append(this.getIndex()).append("(");
            sb.append(this.nestedElements);
            sb.append(")");
            return sb.toString();
        }
    }

    public static class TableContentPosition
    extends Position {
        public static final int FIRST_IN_ROWGROUP = 1;
        public static final int LAST_IN_ROWGROUP = 2;
        protected List gridUnitParts;
        protected EffRow row;
        protected int flags;

        protected TableContentPosition(LayoutManager lm, List gridUnitParts, EffRow row) {
            super(lm);
            this.gridUnitParts = gridUnitParts;
            this.row = row;
        }

        public boolean getFlag(int which) {
            return (this.flags & 1 << which) != 0;
        }

        public void setFlag(int which, boolean value) {
            this.flags = value ? (this.flags |= 1 << which) : (this.flags &= ~(1 << which));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("TableContentPosition:");
            sb.append(this.getIndex());
            sb.append("[");
            sb.append(this.row.getIndex()).append("/");
            sb.append(this.getFlag(1) ? "F" : "-");
            sb.append(this.getFlag(2) ? "L" : "-").append("]");
            sb.append("(");
            sb.append(this.gridUnitParts);
            sb.append(")");
            return sb.toString();
        }
    }

    protected static class GridUnitPart {
        protected PrimaryGridUnit pgu;
        protected int start;
        protected int end;

        protected GridUnitPart(PrimaryGridUnit pgu, int start, int end) {
            this.pgu = pgu;
            this.start = start;
            this.end = end;
        }

        public boolean isFirstPart() {
            return this.start == 0;
        }

        public boolean isLastPart() {
            return this.end >= 0 && this.end == this.pgu.getElements().size() - 1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Part: ");
            sb.append(this.start).append("-").append(this.end);
            sb.append(" [").append(this.isFirstPart() ? "F" : "-").append(this.isLastPart() ? "L" : "-");
            sb.append("] ").append(this.pgu);
            return sb.toString();
        }
    }

    private class RowPainter {
        private TableRow rowFO = null;
        private int colCount = TableContentLayoutManager.this.getColumns().getColumnCount();
        private int yoffset = 0;
        private int accumulatedBPD = 0;
        private EffRow lastRow = null;
        private LayoutContext layoutContext;
        private int lastRowHeight = 0;
        private int[] firstRow = new int[3];
        private Map[] rowOffsets = new Map[]{new HashMap(), new HashMap(), new HashMap()};
        private PrimaryGridUnit[] gridUnits = new PrimaryGridUnit[this.colCount];
        private int[] start = new int[this.colCount];
        private int[] end = new int[this.colCount];
        private int[] partLength = new int[this.colCount];

        public RowPainter(LayoutContext layoutContext) {
            this.layoutContext = layoutContext;
            Arrays.fill(this.firstRow, -1);
            Arrays.fill(this.end, -1);
        }

        public int getAccumulatedBPD() {
            return this.accumulatedBPD;
        }

        public void notifyEndOfSequence() {
            this.accumulatedBPD += this.lastRowHeight;
        }

        public void handleTableContentPosition(TableContentPosition tcpos) {
            if (this.lastRow != tcpos.row && this.lastRow != null) {
                this.addAreasAndFlushRow(false);
                this.yoffset += this.lastRowHeight;
                this.accumulatedBPD += this.lastRowHeight;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("===handleTableContentPosition(" + tcpos));
            }
            this.rowFO = tcpos.row.getTableRow();
            this.lastRow = tcpos.row;
            Iterator partIter = tcpos.gridUnitParts.iterator();
            while (partIter.hasNext()) {
                int colIndex;
                GridUnitPart gup = (GridUnitPart)partIter.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">" + gup));
                }
                if (this.gridUnits[colIndex = gup.pgu.getStartCol()] != gup.pgu) {
                    if (this.gridUnits[colIndex] != null) {
                        log.warn((Object)("Replacing GU in slot " + colIndex + ". Some content may not be painted."));
                    }
                    this.gridUnits[colIndex] = gup.pgu;
                    this.start[colIndex] = gup.start;
                    this.end[colIndex] = gup.end;
                    continue;
                }
                if (gup.end < this.end[colIndex]) {
                    throw new IllegalStateException("Internal Error: stepper problem");
                }
                this.end[colIndex] = gup.end;
            }
        }

        public int addAreasAndFlushRow(boolean forcedFlush) {
            int i;
            int actualRowHeight = 0;
            int readyCount = 0;
            int bt = this.lastRow.getBodyType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remembering yoffset for row " + this.lastRow.getIndex() + ": " + this.yoffset));
            }
            this.rowOffsets[bt].put(new Integer(this.lastRow.getIndex()), new Integer(this.yoffset));
            for (i = 0; i < this.gridUnits.length; ++i) {
                int startRow;
                Integer storedOffset;
                int len;
                if (this.gridUnits[i] == null || !forcedFlush && this.end[i] != this.gridUnits[i].getElements().size() - 1) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("getting len for " + i + " " + this.start[i] + "-" + this.end[i]));
                }
                ++readyCount;
                this.partLength[i] = len = ElementListUtils.calcContentLength(this.gridUnits[i].getElements(), this.start[i], this.end[i]);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("len of part: " + len));
                }
                if (this.start[i] == 0) {
                    int opt;
                    int min;
                    LengthRangeProperty bpd = this.gridUnits[i].getCell().getBlockProgressionDimension();
                    if (!bpd.getMinimum(TableContentLayoutManager.this.getTableLM()).isAuto() && (min = bpd.getMinimum(TableContentLayoutManager.this.getTableLM()).getLength().getValue(TableContentLayoutManager.this.getTableLM())) > 0) {
                        len = Math.max(len, bpd.getMinimum(TableContentLayoutManager.this.getTableLM()).getLength().getValue(TableContentLayoutManager.this.getTableLM()));
                    }
                    if (!bpd.getOptimum(TableContentLayoutManager.this.getTableLM()).isAuto() && (opt = bpd.getOptimum(TableContentLayoutManager.this.getTableLM()).getLength().getValue(TableContentLayoutManager.this.getTableLM())) > 0) {
                        len = Math.max(len, opt);
                    }
                    if (this.gridUnits[i].getRow() != null && !(bpd = this.gridUnits[i].getRow().getBlockProgressionDimension()).getMinimum(TableContentLayoutManager.this.getTableLM()).isAuto() && (min = bpd.getMinimum(TableContentLayoutManager.this.getTableLM()).getLength().getValue(TableContentLayoutManager.this.getTableLM())) > 0) {
                        len = Math.max(len, min);
                    }
                }
                len += this.gridUnits[i].getBorders().getPaddingBefore(false, this.gridUnits[i].getCellLM());
                len += this.gridUnits[i].getBorders().getPaddingAfter(false, this.gridUnits[i].getCellLM());
                if (TableContentLayoutManager.this.isSeparateBorderModel()) {
                    len += this.gridUnits[i].getBorders().getBorderBeforeWidth(false);
                    len += this.gridUnits[i].getBorders().getBorderAfterWidth(false);
                }
                int effYOffset = (storedOffset = (Integer)this.rowOffsets[bt].get(new Integer(startRow = Math.max(this.gridUnits[i].getStartRow(), this.firstRow[bt])))) != null ? storedOffset : this.yoffset;
                actualRowHeight = Math.max(actualRowHeight, len -= this.yoffset - effYOffset);
            }
            if (readyCount == 0) {
                return 0;
            }
            this.lastRowHeight = actualRowHeight += 2 * TableContentLayoutManager.this.getTableLM().getHalfBorderSeparationBPD();
            TableContentLayoutManager.this.addRowBackgroundArea(this.rowFO, actualRowHeight, this.layoutContext.getRefIPD(), this.yoffset);
            for (i = 0; i < this.gridUnits.length; ++i) {
                PrimaryGridUnit gu;
                GridUnit currentGU = this.lastRow.safelyGetGridUnit(i);
                if ((this.gridUnits[i] == null || !forcedFlush && (this.end[i] != this.gridUnits[i].getElements().size() - 1 || currentGU != null && !currentGU.isLastGridUnitRowSpan())) && (this.gridUnits[i] != null || currentGU == null)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)((forcedFlush ? "FORCED " : "") + "flushing..." + i + " " + this.start[i] + "-" + this.end[i]));
                }
                if ((gu = this.gridUnits[i]) == null && !currentGU.isEmpty() && currentGU.getColSpanIndex() == 0 && currentGU.isLastGridUnitColSpan() && (forcedFlush || currentGU.isLastGridUnitRowSpan())) {
                    gu = currentGU.getPrimary();
                }
                if (gu == null) continue;
                this.addAreasForCell(gu, this.start[i], this.end[i], this.lastRow, this.partLength[i], actualRowHeight);
                this.gridUnits[i] = null;
                this.start[i] = 0;
                this.end[i] = -1;
                this.partLength[i] = 0;
            }
            return actualRowHeight;
        }

        private void addAreasForCell(PrimaryGridUnit pgu, int startPos, int endPos, EffRow row, int contentHeight, int rowHeight) {
            int bt = row.getBodyType();
            if (this.firstRow[bt] < 0) {
                this.firstRow[bt] = row.getIndex();
            }
            int startRow = Math.max(pgu.getStartRow(), this.firstRow[bt]);
            Integer offset = (Integer)this.rowOffsets[bt].get(new Integer(startRow));
            while (offset == null) {
                offset = (Integer)this.rowOffsets[bt].get(new Integer(--startRow));
            }
            int effYOffset = offset;
            int effCellHeight = rowHeight;
            effCellHeight += this.yoffset - effYOffset;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating area for cell:");
                log.debug((Object)("  current row: " + row.getIndex()));
                log.debug((Object)("  start row: " + pgu.getStartRow() + " " + this.yoffset + " " + effYOffset));
                log.debug((Object)("  contentHeight: " + contentHeight + " rowHeight=" + rowHeight + " effCellHeight=" + effCellHeight));
            }
            TableCellLayoutManager cellLM = pgu.getCellLM();
            cellLM.setXOffset(TableContentLayoutManager.this.getXOffsetOfGridUnit(pgu));
            cellLM.setYOffset(effYOffset);
            cellLM.setContentHeight(contentHeight);
            cellLM.setRowHeight(effCellHeight);
            int prevBreak = ElementListUtils.determinePreviousBreak(pgu.getElements(), startPos);
            if (endPos >= 0) {
                SpaceResolver.performConditionalsNotification(pgu.getElements(), startPos, endPos, prevBreak);
            }
            cellLM.addAreas(new KnuthPossPosIter(pgu.getElements(), startPos, endPos + 1), this.layoutContext);
        }
    }
}

