/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.LayoutManager;

public abstract class AbstractBaseLayoutManager
implements LayoutManager,
PercentBaseContext {
    protected boolean generatesReferenceArea = false;
    protected boolean generatesBlockArea = false;
    protected FObj fobj = null;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$LayoutManager == null ? (class$org$apache$fop$layoutmgr$LayoutManager = AbstractBaseLayoutManager.class$("org.apache.fop.layoutmgr.LayoutManager")) : class$org$apache$fop$layoutmgr$LayoutManager));
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$LayoutManager;

    public AbstractBaseLayoutManager() {
    }

    public AbstractBaseLayoutManager(FObj fo) {
        this.fobj = fo;
        this.setGeneratesReferenceArea(fo.generatesReferenceAreas());
        if (this.getGeneratesReferenceArea()) {
            this.setGeneratesBlockArea(true);
        }
    }

    public int getBaseLength(int lengthBase, FObj fobj) {
        LayoutManager lm;
        if (fobj == this.getFObj()) {
            switch (lengthBase) {
                case 5: {
                    return this.getAncestorBlockAreaIPD();
                }
                case 6: {
                    return this.getAncestorBlockAreaBPD();
                }
                case 3: {
                    return this.getParentAreaIPD();
                }
                case 4: {
                    return this.getReferenceAreaIPD();
                }
            }
            log.error((Object)new Exception("Unknown base type for LengthBase:" + lengthBase));
            return 0;
        }
        for (lm = this.getParent(); lm != null && fobj != lm.getFObj(); lm = lm.getParent()) {
        }
        if (lm != null) {
            return lm.getBaseLength(lengthBase, fobj);
        }
        log.error((Object)"Cannot find LM to handle given FO for LengthBase.");
        return 0;
    }

    protected int getAncestorBlockAreaIPD() {
        LayoutManager lm;
        for (lm = this.getParent(); lm != null; lm = lm.getParent()) {
            if (!lm.getGeneratesBlockArea() || lm.getGeneratesLineArea()) continue;
            return lm.getContentAreaIPD();
        }
        if (lm == null) {
            log.error((Object)"No parent LM found");
        }
        return 0;
    }

    protected int getAncestorBlockAreaBPD() {
        LayoutManager lm;
        for (lm = this.getParent(); lm != null; lm = lm.getParent()) {
            if (!lm.getGeneratesBlockArea() || lm.getGeneratesLineArea()) continue;
            return lm.getContentAreaBPD();
        }
        if (lm == null) {
            log.error((Object)"No parent LM found");
        }
        return 0;
    }

    protected int getParentAreaIPD() {
        LayoutManager lm = this.getParent();
        if (lm != null) {
            return lm.getContentAreaIPD();
        }
        log.error((Object)"No parent LM found");
        return 0;
    }

    protected int getParentAreaBPD() {
        LayoutManager lm = this.getParent();
        if (lm != null) {
            return lm.getContentAreaBPD();
        }
        log.error((Object)"No parent LM found");
        return 0;
    }

    public int getReferenceAreaIPD() {
        LayoutManager lm;
        for (lm = this.getParent(); lm != null; lm = lm.getParent()) {
            if (!lm.getGeneratesReferenceArea()) continue;
            return lm.getContentAreaIPD();
        }
        if (lm == null) {
            log.error((Object)"No parent LM found");
        }
        return 0;
    }

    protected int getReferenceAreaBPD() {
        LayoutManager lm;
        for (lm = this.getParent(); lm != null; lm = lm.getParent()) {
            if (!lm.getGeneratesReferenceArea()) continue;
            return lm.getContentAreaBPD();
        }
        if (lm == null) {
            log.error((Object)"No parent LM found");
        }
        return 0;
    }

    public int getContentAreaIPD() {
        log.error((Object)"getContentAreaIPD called when it should have been overwritten");
        return 0;
    }

    public int getContentAreaBPD() {
        log.error((Object)"getContentAreaBPD called when it should have been overwritten");
        return 0;
    }

    public boolean getGeneratesReferenceArea() {
        return this.generatesReferenceArea;
    }

    protected void setGeneratesReferenceArea(boolean generatesReferenceArea) {
        this.generatesReferenceArea = generatesReferenceArea;
    }

    public boolean getGeneratesBlockArea() {
        return this.generatesBlockArea;
    }

    protected void setGeneratesBlockArea(boolean generatesBlockArea) {
        this.generatesBlockArea = generatesBlockArea;
    }

    public boolean getGeneratesLineArea() {
        return false;
    }

    public FObj getFObj() {
        return this.fobj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

