/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import java.util.StringTokenizer;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class ColorTypeProperty
extends Property
implements ColorType {
    protected float red;
    protected float green;
    protected float blue;
    protected float alpha;
    protected static final String[] NAMES = new String[]{"aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkgrey", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "ghostwhite", "gold", "goldenrod", "gray", "grey", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightgrey", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"};
    protected static final int[][] VALUES = new int[][]{{240, 248, 255}, {250, 235, 215}, {0, 255, 255}, {127, 255, 212}, {240, 255, 255}, {245, 245, 220}, {255, 228, 196}, {0, 0, 0}, {255, 235, 205}, {0, 0, 255}, {138, 43, 226}, {165, 42, 42}, {222, 184, 135}, {95, 158, 160}, {127, 255, 0}, {210, 105, 30}, {255, 127, 80}, {100, 149, 237}, {255, 248, 220}, {220, 20, 60}, {0, 255, 255}, {0, 0, 139}, {0, 139, 139}, {184, 134, 11}, {169, 169, 169}, {0, 100, 0}, {169, 169, 169}, {189, 183, 107}, {139, 0, 139}, {85, 107, 47}, {255, 140, 0}, {153, 50, 204}, {139, 0, 0}, {233, 150, 122}, {143, 188, 143}, {72, 61, 139}, {47, 79, 79}, {47, 79, 79}, {0, 206, 209}, {148, 0, 211}, {255, 20, 147}, {0, 191, 255}, {105, 105, 105}, {105, 105, 105}, {30, 144, 255}, {178, 34, 34}, {255, 250, 240}, {34, 139, 34}, {255, 0, 255}, {220, 220, 220}, {255, 182, 193}, {255, 160, 122}, {32, 178, 170}, {135, 206, 250}, {119, 136, 153}, {119, 136, 153}, {176, 196, 222}, {255, 255, 224}, {0, 255, 0}, {50, 205, 50}, {250, 240, 230}, {255, 0, 255}, {128, 0, 0}, {102, 205, 170}, {0, 0, 205}, {186, 85, 211}, {147, 112, 219}, {60, 179, 113}, {123, 104, 238}, {0, 250, 154}, {72, 209, 204}, {199, 21, 133}, {25, 25, 112}, {245, 255, 250}, {255, 228, 225}, {255, 228, 181}, {255, 222, 173}, {0, 0, 128}, {253, 245, 230}, {128, 128, 0}, {107, 142, 35}, {255, 165, 0}, {255, 69, 0}, {218, 112, 214}, {238, 232, 170}, {152, 251, 152}, {175, 238, 238}, {219, 112, 147}, {255, 239, 213}, {255, 218, 185}, {205, 133, 63}, {255, 192, 203}, {221, 160, 221}, {176, 224, 230}, {128, 0, 128}, {255, 0, 0}, {188, 143, 143}, {65, 105, 225}, {139, 69, 19}, {250, 128, 114}, {248, 248, 255}, {255, 215, 0}, {218, 165, 32}, {128, 128, 128}, {128, 128, 128}, {0, 128, 0}, {173, 255, 47}, {240, 255, 240}, {255, 105, 180}, {205, 92, 92}, {75, 0, 130}, {255, 255, 240}, {240, 230, 140}, {230, 230, 250}, {255, 240, 245}, {124, 252, 0}, {255, 250, 205}, {173, 216, 230}, {240, 128, 128}, {224, 255, 255}, {250, 250, 210}, {211, 211, 211}, {144, 238, 144}, {211, 211, 211}, {244, 164, 96}, {46, 139, 87}, {255, 245, 238}, {160, 82, 45}, {192, 192, 192}, {135, 206, 235}, {106, 90, 205}, {112, 128, 144}, {112, 128, 144}, {255, 250, 250}, {0, 255, 127}, {70, 130, 180}, {210, 180, 140}, {0, 128, 128}, {216, 191, 216}, {255, 99, 71}, {64, 224, 208}, {238, 130, 238}, {245, 222, 179}, {255, 255, 255}, {245, 245, 245}, {255, 255, 0}, {154, 205, 50}};

    public ColorTypeProperty(float red, float green, float blue) {
        this.red = 0.0f;
        this.green = 0.0f;
        this.blue = 0.0f;
        this.alpha = 1.0f;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    /*
     * Unable to fully structure code
     */
    public ColorTypeProperty(String value) throws PropertyException {
        block20: {
            super();
            this.red = 0.0f;
            this.green = 0.0f;
            this.blue = 0.0f;
            this.alpha = 1.0f;
            if (!value.startsWith("#")) break block20;
            try {
                if (value.length() == 4) {
                    this.red = (float)Integer.parseInt(value.substring(1, 2), 16) / 15.0f;
                    this.green = (float)Integer.parseInt(value.substring(2, 3), 16) / 15.0f;
                    this.blue = (float)Integer.parseInt(value.substring(3), 16) / 15.0f;
                }
                if (value.length() == 7) {
                    this.red = (float)Integer.parseInt(value.substring(1, 3), 16) / 255.0f;
                    this.green = (float)Integer.parseInt(value.substring(3, 5), 16) / 255.0f;
                    this.blue = (float)Integer.parseInt(value.substring(5), 16) / 255.0f;
                }
                throw new PropertyException("Unknown color format: " + value + ". Must be #RGB or #RRGGBB");
            }
            catch (NumberFormatException e) {
                throw new PropertyException("Unknown color format: " + value + ". Must be #RGB or #RRGGBB");
            }
        }
        if (!value.startsWith("rgb(")) ** GOTO lbl45
        poss = value.indexOf("(");
        pose = value.indexOf(")");
        if (poss != -1 && pose != -1) {
            value = value.substring(poss + 1, pose);
            st = new StringTokenizer(value, ",");
            try {
                if (st.hasMoreTokens()) {
                    str = st.nextToken().trim();
                    this.red = str.endsWith("%") != false ? Float.parseFloat(str.substring(0, str.length() - 1)) / 100.0f : Float.parseFloat(str) / 255.0f;
                }
                if (st.hasMoreTokens()) {
                    str = st.nextToken().trim();
                    this.green = str.endsWith("%") != false ? Float.parseFloat(str.substring(0, str.length() - 1)) / 100.0f : Float.parseFloat(str) / 255.0f;
                }
                if (!st.hasMoreTokens()) ** GOTO lbl70
                str = st.nextToken().trim();
                if (str.endsWith("%")) {
                    this.blue = Float.parseFloat(str.substring(0, str.length() - 1)) / 100.0f;
                }
                this.blue = Float.parseFloat(str) / 255.0f;
            }
            catch (Exception e) {
                throw new PropertyException("Arguments to rgb() must be [0..255] or [0%..100%]");
            }
        } else {
            throw new PropertyException("Unknown color format: " + value + ". Must be rgb(r,g,b)");
lbl45:
            // 1 sources

            if (value.startsWith("url(")) {
                throw new PropertyException("Colors starting with url( are not yet supported!");
            }
            if (value.startsWith("system-color(")) {
                poss = value.indexOf("(");
                pose = value.indexOf(")");
                if (poss != -1 && pose != -1) {
                    value = value.substring(poss + 1, pose);
                } else {
                    throw new PropertyException("Unknown color format: " + value + ". Must be system-color(x)");
                }
            }
            if (value.toLowerCase().equals("transparent")) {
                this.red = 0.0f;
                this.green = 0.0f;
                this.blue = 0.0f;
                this.alpha = 0.0f;
            } else {
                found = false;
                for (count = 0; count < ColorTypeProperty.NAMES.length; ++count) {
                    if (!value.toLowerCase().equals(ColorTypeProperty.NAMES[count])) continue;
                    this.red = (float)ColorTypeProperty.VALUES[count][0] / 255.0f;
                    this.green = (float)ColorTypeProperty.VALUES[count][1] / 255.0f;
                    this.blue = (float)ColorTypeProperty.VALUES[count][2] / 255.0f;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new PropertyException("Unknown color name: " + value);
                }
            }
        }
lbl70:
        // 8 sources

        if ((double)this.red < 0.0 || (double)this.red > 1.0 || (double)this.green < 0.0 || (double)this.green > 1.0 || (double)this.blue < 0.0 || (double)this.blue > 1.0 || (double)this.alpha < 0.0 || (double)this.alpha > 1.0) {
            throw new PropertyException("Color values out of range");
        }
    }

    public float getBlue() {
        return this.blue;
    }

    public float getGreen() {
        return this.green;
    }

    public float getRed() {
        return this.red;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color getAWTColor() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    public static int convertChannelToInteger(float floatValue) {
        if ((double)floatValue > 1.0) {
            floatValue = 1.0f;
        }
        if (floatValue < 0.0f) {
            floatValue = 0.0f;
        }
        return (int)(floatValue * 255.0f);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(8);
        sbuf.append('#');
        String s = Integer.toHexString((int)((double)this.red * 255.0));
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        s = Integer.toHexString((int)((double)this.green * 255.0));
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        s = Integer.toHexString((int)((double)this.blue * 255.0));
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        return sbuf.toString();
    }

    public ColorTypeProperty getColorType() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof ColorTypeProperty) {
                return p;
            }
            ColorTypeProperty val = p.getColorType();
            if (val != null) {
                return val;
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

