/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOURIResolver;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.hyphenation.HyphenationTreeResolver;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.render.RendererFactory;
import org.apache.fop.render.XMLHandlerRegistry;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.xml.sax.SAXException;

public class FopFactory {
    private static final float DEFAULT_SOURCE_RESOLUTION = 72.0f;
    private static final String DEFAULT_PAGE_HEIGHT = "11in";
    private static final String DEFAULT_PAGE_WIDTH = "8.26in";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$apps$FopFactory == null ? (class$org$apache$fop$apps$FopFactory = FopFactory.class$("org.apache.fop.apps.FopFactory")) : class$org$apache$fop$apps$FopFactory));
    private RendererFactory rendererFactory = new RendererFactory();
    private XMLHandlerRegistry xmlHandlers = new XMLHandlerRegistry();
    private ElementMappingRegistry elementMappingRegistry;
    private ContentHandlerFactoryRegistry contentHandlerFactoryRegistry = new ContentHandlerFactoryRegistry();
    private URIResolver foURIResolver = new FOURIResolver();
    private URIResolver uriResolver = null;
    private HyphenationTreeResolver hyphResolver;
    private ImageFactory imageFactory = new ImageFactory();
    private Configuration userConfig = null;
    private String fontBaseURL;
    private boolean strictValidation = true;
    private boolean enableBase14Kerning = false;
    private float sourceResolution = 72.0f;
    private String pageHeight = "11in";
    private String pageWidth = "8.26in";
    private boolean breakIndentInheritanceOnReferenceAreaBoundary = false;
    private LayoutManagerMaker lmMakerOverride = null;
    static /* synthetic */ Class class$org$apache$fop$apps$FopFactory;

    protected FopFactory() {
        this.elementMappingRegistry = new ElementMappingRegistry(this);
    }

    public static FopFactory newInstance() {
        return new FopFactory();
    }

    public FOUserAgent newFOUserAgent() {
        FOUserAgent userAgent = new FOUserAgent(this);
        return userAgent;
    }

    public Fop newFop(String outputFormat) throws FOPException {
        return new Fop(outputFormat, this.newFOUserAgent());
    }

    public Fop newFop(String outputFormat, FOUserAgent userAgent) throws FOPException {
        if (userAgent == null) {
            throw new NullPointerException("The userAgent parameter must not be null!");
        }
        return new Fop(outputFormat, userAgent);
    }

    public Fop newFop(String outputFormat, OutputStream stream) throws FOPException {
        return new Fop(outputFormat, this.newFOUserAgent(), stream);
    }

    public Fop newFop(String outputFormat, FOUserAgent userAgent, OutputStream stream) throws FOPException {
        if (userAgent == null) {
            throw new NullPointerException("The userAgent parameter must not be null!");
        }
        return new Fop(outputFormat, userAgent, stream);
    }

    public Fop newFop(FOUserAgent userAgent) throws FOPException {
        if (userAgent.getRendererOverride() == null && userAgent.getFOEventHandlerOverride() == null) {
            throw new IllegalStateException("Either the overriding renderer or the overriding FOEventHandler must be set when this factory method is used!");
        }
        return this.newFop(null, userAgent);
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.xmlHandlers;
    }

    public ElementMappingRegistry getElementMappingRegistry() {
        return this.elementMappingRegistry;
    }

    public ContentHandlerFactoryRegistry getContentHandlerFactoryRegistry() {
        return this.contentHandlerFactoryRegistry;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public void addElementMapping(ElementMapping elementMapping) {
        this.elementMappingRegistry.addElementMapping(elementMapping);
    }

    public void setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
        this.lmMakerOverride = lmMaker;
    }

    public LayoutManagerMaker getLayoutManagerMakerOverride() {
        return this.lmMakerOverride;
    }

    public void setFontBaseURL(String fontBaseURL) {
        this.fontBaseURL = fontBaseURL;
    }

    public String getFontBaseURL() {
        return this.fontBaseURL;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public HyphenationTreeResolver getHyphenationTreeResolver() {
        return this.hyphResolver;
    }

    public void setStrictValidation(boolean validateStrictly) {
        this.strictValidation = validateStrictly;
    }

    public boolean validateStrictly() {
        return this.strictValidation;
    }

    public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
        return this.breakIndentInheritanceOnReferenceAreaBoundary;
    }

    public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean value) {
        this.breakIndentInheritanceOnReferenceAreaBoundary = value;
    }

    public boolean isBase14KerningEnabled() {
        return this.enableBase14Kerning;
    }

    public void setBase14KerningEnabled(boolean value) {
        this.enableBase14Kerning = value;
    }

    public float getSourceResolution() {
        return this.sourceResolution;
    }

    public float getSourcePixelUnitToMillimeter() {
        return 25.4f / this.getSourceResolution();
    }

    public void setSourceResolution(int dpi) {
        this.sourceResolution = dpi;
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(String pageWidth) {
        this.pageWidth = pageWidth;
    }

    public void setUserConfig(File userConfigFile) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.buildFromFile(userConfigFile));
        }
        catch (ConfigurationException cfge) {
            log.error((Object)("Error loading configuration: " + cfge.getMessage()));
        }
    }

    public void setUserConfig(String uri) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.build(uri));
        }
        catch (ConfigurationException cfge) {
            log.error((Object)("Error loading configuration: " + cfge.getMessage()));
        }
    }

    public void setUserConfig(Configuration userConfig) {
        this.userConfig = userConfig;
        try {
            this.initUserConfig();
        }
        catch (ConfigurationException cfge) {
            log.error((Object)("Error initializing factory configuration: " + cfge.getMessage()));
        }
    }

    public Configuration getUserConfig() {
        return this.userConfig;
    }

    public void initUserConfig() throws ConfigurationException {
        Configuration pageConfig;
        log.debug((Object)"Initializing User Agent Configuration");
        this.setFontBaseURL(FopFactory.getBaseURLfromConfig(this.userConfig, "font-base"));
        final String hyphBase = FopFactory.getBaseURLfromConfig(this.userConfig, "hyphenation-base");
        if (hyphBase != null) {
            this.hyphResolver = new HyphenationTreeResolver(){

                public Source resolve(String href) {
                    return FopFactory.this.resolveURI(href, hyphBase);
                }
            };
        }
        if (this.userConfig.getChild("source-resolution", false) != null) {
            this.sourceResolution = this.userConfig.getChild("source-resolution").getValueAsFloat(72.0f);
            log.info((Object)("Source resolution set to: " + this.sourceResolution + "dpi (px2mm=" + this.getSourcePixelUnitToMillimeter() + ")"));
        }
        if (this.userConfig.getChild("strict-validation", false) != null) {
            this.strictValidation = this.userConfig.getChild("strict-validation").getValueAsBoolean();
        }
        if (this.userConfig.getChild("break-indent-inheritance", false) != null) {
            this.breakIndentInheritanceOnReferenceAreaBoundary = this.userConfig.getChild("break-indent-inheritance").getValueAsBoolean();
        }
        if ((pageConfig = this.userConfig.getChild("default-page-settings")).getAttribute("height", null) != null) {
            this.setPageHeight(pageConfig.getAttribute("height"));
            log.info((Object)("Default page-height set to: " + this.pageHeight));
        }
        if (pageConfig.getAttribute("width", null) != null) {
            this.setPageWidth(pageConfig.getAttribute("width"));
            log.info((Object)("Default page-width set to: " + this.pageWidth));
        }
    }

    public static String getBaseURLfromConfig(Configuration cfg, String name) {
        if (cfg.getChild(name, false) != null) {
            try {
                File dir;
                String cfgBaseDir = cfg.getChild(name).getValue(null);
                if (cfgBaseDir != null && (dir = new File(cfgBaseDir)).isDirectory()) {
                    cfgBaseDir = dir.toURL().toExternalForm();
                }
                log.info((Object)(name + " set to: " + cfgBaseDir));
                return cfgBaseDir;
            }
            catch (MalformedURLException mue) {
                log.error((Object)"Base URL in user config is malformed!");
            }
        }
        return null;
    }

    public Source resolveURI(String uri, String base) {
        Source source = null;
        if (this.uriResolver != null) {
            try {
                source = this.uriResolver.resolve(uri, base);
            }
            catch (TransformerException te) {
                log.error((Object)("Attempt to resolve URI '" + uri + "' failed: "), (Throwable)te);
            }
        }
        if (source == null) {
            try {
                source = this.foURIResolver.resolve(uri, base);
            }
            catch (TransformerException te) {
                log.error((Object)("Attempt to resolve URI '" + uri + "' failed: "), (Throwable)te);
            }
        }
        return source;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

