/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.jsr223;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.mvel.MVEL;
import org.mvel.jsr223.MVELScriptEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELScriptEngineFactory
implements ScriptEngineFactory {
    private static final String NULL_SYMBOL = "null";
    private static final String STATEMENT_TERMINATOR = ";";
    static final List<String> extentions = Collections.unmodifiableList(Arrays.asList("mvel"));
    static final List<String> mimeTypes = Collections.unmodifiableList(Arrays.asList("application/x-mvel", "application/x-mvel-source"));
    static final List<String> names = Collections.unmodifiableList(Arrays.asList("mvel"));

    @Override
    public String getEngineName() {
        return "MVEL (MVFLEX Expression Language)";
    }

    @Override
    public String getEngineVersion() {
        return "1.2";
    }

    @Override
    public List<String> getExtensions() {
        return extentions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getLanguageName() {
        return "MVEL (MVFLEX Expression Language)";
    }

    @Override
    public String getLanguageVersion() {
        return "1.2";
    }

    @Override
    public Object getParameter(String param) {
        if (param.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (param.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (param.equals("javax.script.name")) {
            return this.getEngineName();
        }
        if (param.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (param.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (param.equals("THREADING")) {
            return MVEL.isThreadSafe() ? "MULTITHREADED" : null;
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String object, String method, String ... arguments) {
        StringBuffer sb = new StringBuffer();
        if (object != null) {
            sb.append(object).append('.');
        }
        sb.append(method).append('(');
        if (arguments.length > 0) {
            sb.append(' ');
        }
        for (int i = 0; i < arguments.length; ++i) {
            sb.append(arguments[i] == null ? NULL_SYMBOL : arguments[i]).append(i < arguments.length - 1 ? ", " : Character.valueOf(' '));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String message) {
        return message;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuffer sb = new StringBuffer();
        for (String stmt : statements) {
            sb.append(stmt);
            if (!stmt.endsWith(STATEMENT_TERMINATOR)) {
                sb.append(STATEMENT_TERMINATOR);
            }
            sb.append('\n');
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new MVELScriptEngine(this);
    }
}

