/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.jsr223;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.PropertyAccessException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.jsr223.MVELCompiledScript;
import org.mvel.jsr223.MVELScriptContextMap;
import org.mvel.jsr223.MVELScriptEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String THIS_SYMBOL = "this";
    private static final int CHAR_BUFFER_SIZE = 512;
    private ScriptEngineFactory scriptingEngineFactory;

    public MVELScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    protected MVELScriptEngine(ScriptEngineFactory scriptingEngineFactory) {
        this.scriptingEngineFactory = scriptingEngineFactory;
    }

    @Override
    public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("The expression argument can not be null.");
        }
        if (scriptContext == null) {
            throw new NullPointerException("The ScriptContext argument can not be null.");
        }
        try {
            ExecutableStatement executableStatement = (ExecutableStatement)MVEL.compileExpression((String)script);
            MVELScriptContextMap scriptContextEngineView = new MVELScriptContextMap(scriptContext);
            MapVariableResolverFactory variableResolverFactory = new MapVariableResolverFactory((Map)scriptContextEngineView);
            return executableStatement.getValue((Object)scriptContext, (VariableResolverFactory)variableResolverFactory);
        }
        catch (CompileException ce) {
            throw new ScriptException(ce.getMessage(), new String(ce.getExpr()), ce.getCursor());
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        if (reader == null) {
            throw new NullPointerException("The Reader argument can not be null.");
        }
        if (scriptContext == null) {
            throw new NullPointerException("The ScriptContext argument can not be null.");
        }
        StringBuilder builder = new StringBuilder();
        CharBuffer cb = CharBuffer.allocate(512);
        try {
            while (reader.read(cb) != -1) {
                builder.append(cb.array());
            }
            return this.eval(builder.toString(), scriptContext);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (CompileException ce) {
            throw new ScriptException(ce.getMessage(), new String(ce.getExpr()), ce.getCursor());
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.scriptingEngineFactory == null) {
            this.scriptingEngineFactory = new MVELScriptEngineFactory();
        }
        return this.scriptingEngineFactory;
    }

    @Override
    public CompiledScript compile(String expression) throws ScriptException {
        if (expression == null) {
            throw new NullPointerException("The expression argument can not be null.");
        }
        try {
            ExecutableStatement executableStatement = (ExecutableStatement)MVEL.compileExpression((String)expression);
            return new MVELCompiledScript(this, executableStatement);
        }
        catch (CompileException ce) {
            throw new ScriptException(ce.getMessage(), new String(ce.getExpr()), ce.getCursor());
        }
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        if (reader == null) {
            throw new NullPointerException("The Reader argument can not be null.");
        }
        StringBuilder builder = new StringBuilder();
        CharBuffer cb = CharBuffer.allocate(512);
        try {
            while (reader.read(cb) != -1) {
                builder.append(cb.array());
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        try {
            ExecutableStatement executableStatement = (ExecutableStatement)MVEL.compileExpression((String)builder.toString());
            return new MVELCompiledScript(this, executableStatement);
        }
        catch (CompileException ce) {
            throw new ScriptException(ce.getMessage(), new String(ce.getExpr()), ce.getCursor());
        }
    }

    @Override
    public Object invokeMethod(Object thiz, String method, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("The target object can not be null.");
        }
        if (method == null) {
            throw new NullPointerException("The method name argument can not be null.");
        }
        String[] arguments = this.convertToStringArray(args);
        String syntax = this.scriptingEngineFactory.getMethodCallSyntax(THIS_SYMBOL, method, arguments);
        try {
            return MVEL.eval((String)syntax, (Object)thiz);
        }
        catch (PropertyAccessException pae) {
            throw new NoSuchMethodException(pae.getMessage());
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        throw new ScriptException("This operation is unsupported.");
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        throw new IllegalArgumentException("This operation is unsupported.");
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clazz) {
        throw new IllegalArgumentException("This operation is unsupported.");
    }

    private String[] convertToStringArray(Object ... args) {
        if (args != null) {
            String[] stringArguments = new String[args.length];
            int i = 0;
            for (Object arg : args) {
                stringArguments[i++] = arg instanceof String || arg instanceof Character ? "'" + arg + "'" : String.valueOf(arg);
            }
            return stringArguments;
        }
        return EMPTY_STRING_ARRAY;
    }
}

