/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import org.milyn.container.ExecutionContext;

public class BeanAccessor {
    private static final String BEAN_MAP_REQUEST_KEY = BeanAccessor.class.getName() + "#BEAN_MAP_REQUEST_KEY";

    public static Object getBean(String beanId, ExecutionContext request) {
        if (beanId == null) {
            throw new IllegalArgumentException("null 'beanId' arg in method call.");
        }
        if (request == null) {
            throw new IllegalArgumentException("null 'request' arg in method call.");
        }
        HashMap beans = BeanAccessor.getBeans(request);
        Object bean = beans.get(beanId);
        return bean;
    }

    public static HashMap getBeans(ExecutionContext request) {
        if (request == null) {
            throw new IllegalArgumentException("null 'request' arg in method call.");
        }
        LinkedHashMap beans = (LinkedHashMap)request.getAttribute((Object)BEAN_MAP_REQUEST_KEY);
        if (beans == null) {
            beans = new LinkedHashMap();
            request.setAttribute((Object)BEAN_MAP_REQUEST_KEY, beans);
        }
        return beans;
    }

    public static void addBean(String beanId, Object bean, ExecutionContext request, boolean addToList) {
        if (beanId == null) {
            throw new IllegalArgumentException("null 'beanId' arg in method call.");
        }
        if (bean == null) {
            throw new IllegalArgumentException("null 'bean' arg in method call.");
        }
        if (request == null) {
            throw new IllegalArgumentException("null 'request' arg in method call.");
        }
        HashMap beans = BeanAccessor.getBeans(request);
        if (addToList) {
            String beanListId = beanId + "List";
            Object beanList = beans.get(beanListId);
            if (beanList == null) {
                beanList = new Vector();
                beans.put(beanListId, beanList);
            } else if (!(beanList instanceof List)) {
                throw new IllegalArgumentException("bean [" + beanId + "] already exists on request and IS NOT a List.  Arg 'addToList' set to true - this is inconsistent!!");
            }
            ((List)beanList).add(bean);
        } else {
            Object currentBean = beans.get(beanId);
            if (currentBean instanceof List) {
                throw new IllegalArgumentException("bean [" + beanId + "] already exists on request and IS a List.  Arg 'addToList' set to false - this is inconsistent!!");
            }
        }
        beans.put(beanId, bean);
    }
}

