/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import junit.framework.TestCase;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockNotificationTarget
extends NotificationTarget {
    private static Hashtable<String, List<Serializable>> targetLists = new Hashtable();
    private List<Serializable> targetList;

    public MockNotificationTarget(ConfigTree config) {
        super(config);
        String name = config.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            TestCase.fail((String)"Mock NotificationTarget configured incorrectly.  Must specify a 'name' attribute on the NotificationList/target element.");
        }
        this.targetList = MockNotificationTarget.getTargetList(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Serializable> getTargetList(String name) {
        Hashtable<String, List<Serializable>> hashtable = targetLists;
        synchronized (hashtable) {
            List<Serializable> notificationList = targetLists.get(name);
            if (notificationList == null) {
                notificationList = new ArrayList<Serializable>();
                targetLists.put(name, notificationList);
            }
            return notificationList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearNotifications() {
        Hashtable<String, List<Serializable>> hashtable = targetLists;
        synchronized (hashtable) {
            targetLists.clear();
        }
    }

    public void sendNotification(Message notificationObject) throws NotificationException {
        this.targetList.add((Serializable)((Object)notificationObject.getBody().get().toString()));
    }
}

