/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TestEnvironmentUtil {
    private static Logger log = Logger.getLogger(TestEnvironmentUtil.class);

    public static String getUserDir() {
        return TestEnvironmentUtil.getUserDir("product");
    }

    public static String getBaseDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserDir(String dir) {
        String userDir = "";
        String baseDir = System.getProperty("user.dir");
        log.debug((Object)baseDir);
        if (!baseDir.endsWith(dir)) {
            userDir = dir + "/";
        }
        return userDir;
    }

    public static String getUserDir(String eclipseDir, String antDir) {
        String userDir = "";
        String baseDir = System.getProperty("user.dir");
        log.debug((Object)baseDir);
        userDir = !baseDir.endsWith(eclipseDir) ? (baseDir.endsWith("qa") ? antDir + "/" : eclipseDir + "/") : antDir + "/";
        log.debug((Object)userDir);
        return userDir;
    }

    public static void setESBPropertiesFileToUse() {
        String jbossesbPropertiesFile = TestEnvironmentUtil.getUserDir() + "/etc/test/resources/jbossesb-unittest-properties.xml";
        System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
    }

    public static void setESBPropertiesFileToUse(String dir) {
        String jbossesbPropertiesFile = TestEnvironmentUtil.getUserDir(dir) + "/etc/test/resources/jbossesb-unittest-properties.xml";
        System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
    }

    public static void setESBPropertiesFileToUse(String eclipseDir, String antDir) {
        String jbossesbPropertiesFile = TestEnvironmentUtil.getUserDir(eclipseDir, antDir) + "/etc/test/resources/jbossesb-unittest-properties.xml";
        System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
    }

    public static String readTextFile(File file) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new FileReader(file.getPath()));
        char[] chars = new char[1];
        while (reader.read(chars) > -1) {
            sb.append(String.valueOf(chars));
            chars = new char[1];
        }
        reader.close();
        return sb.toString();
    }

    public static File findResourceDirectory(String dirPath) {
        String[] dirs = dirPath.split("/");
        for (int i = 1; i < dirs.length; ++i) {
            dirPath = ".";
            for (int j = i; j < dirs.length; ++j) {
                dirPath = dirPath + "/" + dirs[j];
            }
            File dir = new File(dirPath);
            if (!dir.exists()) continue;
            return dir;
        }
        return null;
    }
}

